/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.kotlin.reflect;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.internal.Util;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterKt;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableMap;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002 !BU\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0006\u0012\u001a\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R'\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R%\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/squareup/moshi/kotlin/reflect/KotlinJsonAdapter;", "T", "Lcom/squareup/moshi/JsonAdapter;", "constructor", "Lkotlin/reflect/KFunction;", "allBindings", "", "Lcom/squareup/moshi/kotlin/reflect/KotlinJsonAdapter$Binding;", "", "nonIgnoredBindings", "options", "Lcom/squareup/moshi/JsonReader$Options;", "(Lkotlin/reflect/KFunction;Ljava/util/List;Ljava/util/List;Lcom/squareup/moshi/JsonReader$Options;)V", "getAllBindings", "()Ljava/util/List;", "getConstructor", "()Lkotlin/reflect/KFunction;", "getNonIgnoredBindings", "getOptions", "()Lcom/squareup/moshi/JsonReader$Options;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "(Lcom/squareup/moshi/JsonReader;)Ljava/lang/Object;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "(Lcom/squareup/moshi/JsonWriter;Ljava/lang/Object;)V", "toString", "", "Binding", "IndexedParameterMap", "reflect"})
public final class KotlinJsonAdapter<T>
extends JsonAdapter<T> {
    @NotNull
    private final KFunction<T> constructor;
    @NotNull
    private final List<Binding<T, Object>> allBindings;
    @NotNull
    private final List<Binding<T, Object>> nonIgnoredBindings;
    @NotNull
    private final JsonReader.Options options;

    public KotlinJsonAdapter(@NotNull KFunction<? extends T> constructor, @NotNull List<Binding<T, Object>> allBindings, @NotNull List<Binding<T, Object>> nonIgnoredBindings, @NotNull JsonReader.Options options) {
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter(allBindings, (String)"allBindings");
        Intrinsics.checkNotNullParameter(nonIgnoredBindings, (String)"nonIgnoredBindings");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.constructor = constructor;
        this.allBindings = allBindings;
        this.nonIgnoredBindings = nonIgnoredBindings;
        this.options = options;
    }

    @NotNull
    public final KFunction<T> getConstructor() {
        return this.constructor;
    }

    @NotNull
    public final List<Binding<T, Object>> getAllBindings() {
        return this.allBindings;
    }

    @NotNull
    public final List<Binding<T, Object>> getNonIgnoredBindings() {
        return this.nonIgnoredBindings;
    }

    @NotNull
    public final JsonReader.Options getOptions() {
        return this.options;
    }

    public T fromJson(@NotNull JsonReader reader) {
        int n;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int constructorSize = this.constructor.getParameters().size();
        int n2 = 0;
        int n3 = this.allBindings.size();
        Object[] objectArray = new Object[n3];
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = KotlinJsonAdapterKt.access$getABSENT_VALUE$p();
        }
        Object[] values = objectArray;
        reader.beginObject();
        while (reader.hasNext()) {
            int index = reader.selectName(this.options);
            if (index == -1) {
                reader.skipName();
                reader.skipValue();
                continue;
            }
            Binding<T, Object> binding = this.nonIgnoredBindings.get(index);
            int propertyIndex = binding.getPropertyIndex();
            if (values[propertyIndex] != KotlinJsonAdapterKt.access$getABSENT_VALUE$p()) {
                throw new JsonDataException("Multiple values for '" + binding.getProperty().getName() + "' at " + reader.getPath());
            }
            values[propertyIndex] = binding.getAdapter().fromJson(reader);
            if (values[propertyIndex] != null || binding.getProperty().getReturnType().isMarkedNullable()) continue;
            JsonDataException jsonDataException = Util.unexpectedNull((String)binding.getProperty().getName(), (String)binding.getJsonName(), (JsonReader)reader);
            Intrinsics.checkNotNullExpressionValue((Object)jsonDataException, (String)"unexpectedNull(\n        \u2026         reader\n        )");
            throw (Throwable)jsonDataException;
        }
        reader.endObject();
        boolean isFullInitialized = this.allBindings.size() == constructorSize;
        for (int i = 0; i < constructorSize; ++i) {
            if (values[i] != KotlinJsonAdapterKt.access$getABSENT_VALUE$p()) continue;
            if (((KParameter)this.constructor.getParameters().get(i)).isOptional()) {
                isFullInitialized = false;
                continue;
            }
            if (((KParameter)this.constructor.getParameters().get(i)).getType().isMarkedNullable()) {
                values[i] = null;
                continue;
            }
            Binding<T, Object> binding = this.allBindings.get(i);
            JsonDataException jsonDataException = Util.missingProperty((String)((KParameter)this.constructor.getParameters().get(i)).getName(), (String)(binding != null ? binding.getJsonName() : null), (JsonReader)reader);
            Intrinsics.checkNotNullExpressionValue((Object)jsonDataException, (String)"missingProperty(\n       \u2026       reader\n          )");
            throw (Throwable)jsonDataException;
        }
        Object result = isFullInitialized ? this.constructor.call(Arrays.copyOf(values, values.length)) : this.constructor.callBy((Map)((Object)new IndexedParameterMap(this.constructor.getParameters(), values)));
        n = this.allBindings.size();
        for (int i = constructorSize; i < n; ++i) {
            Binding<T, Object> binding;
            Intrinsics.checkNotNull(this.allBindings.get(i));
            Object value = values[i];
            binding.set(result, value);
        }
        return (T)result;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        writer.beginObject();
        for (Binding<T, Object> binding : this.allBindings) {
            if (binding == null) continue;
            writer.name(binding.getJsonName());
            binding.getAdapter().toJson(writer, binding.get(value));
        }
        writer.endObject();
    }

    @NotNull
    public String toString() {
        return "KotlinJsonAdapter(" + this.constructor.getReturnType() + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u00020\u0003BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007H\u00c6\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\rH\u00c6\u0003J[\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\u0013\u0010\"\u001a\u00028\u00022\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010$J\t\u0010%\u001a\u00020\rH\u00d6\u0001J\u001b\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00028\u00012\u0006\u0010#\u001a\u00028\u0002\u00a2\u0006\u0002\u0010)J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/squareup/moshi/kotlin/reflect/KotlinJsonAdapter$Binding;", "K", "P", "", "jsonName", "", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "property", "Lkotlin/reflect/KProperty1;", "parameter", "Lkotlin/reflect/KParameter;", "propertyIndex", "", "(Ljava/lang/String;Lcom/squareup/moshi/JsonAdapter;Lkotlin/reflect/KProperty1;Lkotlin/reflect/KParameter;I)V", "getAdapter", "()Lcom/squareup/moshi/JsonAdapter;", "getJsonName", "()Ljava/lang/String;", "getParameter", "()Lkotlin/reflect/KParameter;", "getProperty", "()Lkotlin/reflect/KProperty1;", "getPropertyIndex", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "get", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "set", "", "result", "(Ljava/lang/Object;Ljava/lang/Object;)V", "toString", "reflect"})
    public static final class Binding<K, P> {
        @NotNull
        private final String jsonName;
        @NotNull
        private final JsonAdapter<P> adapter;
        @NotNull
        private final KProperty1<K, P> property;
        @Nullable
        private final KParameter parameter;
        private final int propertyIndex;

        public Binding(@NotNull String jsonName, @NotNull JsonAdapter<P> adapter, @NotNull KProperty1<K, ? extends P> property, @Nullable KParameter parameter, int propertyIndex) {
            Intrinsics.checkNotNullParameter((Object)jsonName, (String)"jsonName");
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.jsonName = jsonName;
            this.adapter = adapter;
            this.property = property;
            this.parameter = parameter;
            this.propertyIndex = propertyIndex;
        }

        @NotNull
        public final String getJsonName() {
            return this.jsonName;
        }

        @NotNull
        public final JsonAdapter<P> getAdapter() {
            return this.adapter;
        }

        @NotNull
        public final KProperty1<K, P> getProperty() {
            return this.property;
        }

        @Nullable
        public final KParameter getParameter() {
            return this.parameter;
        }

        public final int getPropertyIndex() {
            return this.propertyIndex;
        }

        public final P get(K value) {
            return (P)this.property.get(value);
        }

        public final void set(K result, P value) {
            if (value != KotlinJsonAdapterKt.access$getABSENT_VALUE$p()) {
                KProperty1<K, P> kProperty1 = this.property;
                Intrinsics.checkNotNull(kProperty1, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<K of com.squareup.moshi.kotlin.reflect.KotlinJsonAdapter.Binding, P of com.squareup.moshi.kotlin.reflect.KotlinJsonAdapter.Binding>");
                ((KMutableProperty1)kProperty1).set(result, value);
            }
        }

        @NotNull
        public final String component1() {
            return this.jsonName;
        }

        @NotNull
        public final JsonAdapter<P> component2() {
            return this.adapter;
        }

        @NotNull
        public final KProperty1<K, P> component3() {
            return this.property;
        }

        @Nullable
        public final KParameter component4() {
            return this.parameter;
        }

        public final int component5() {
            return this.propertyIndex;
        }

        @NotNull
        public final Binding<K, P> copy(@NotNull String jsonName, @NotNull JsonAdapter<P> adapter, @NotNull KProperty1<K, ? extends P> property, @Nullable KParameter parameter, int propertyIndex) {
            Intrinsics.checkNotNullParameter((Object)jsonName, (String)"jsonName");
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return new Binding<K, P>(jsonName, adapter, property, parameter, propertyIndex);
        }

        public static /* synthetic */ Binding copy$default(Binding binding, String string, JsonAdapter jsonAdapter, KProperty1 kProperty1, KParameter kParameter, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = binding.jsonName;
            }
            if ((n2 & 2) != 0) {
                jsonAdapter = binding.adapter;
            }
            if ((n2 & 4) != 0) {
                kProperty1 = binding.property;
            }
            if ((n2 & 8) != 0) {
                kParameter = binding.parameter;
            }
            if ((n2 & 0x10) != 0) {
                n = binding.propertyIndex;
            }
            return binding.copy(string, jsonAdapter, kProperty1, kParameter, n);
        }

        @NotNull
        public String toString() {
            return "Binding(jsonName=" + this.jsonName + ", adapter=" + this.adapter + ", property=" + this.property + ", parameter=" + this.parameter + ", propertyIndex=" + this.propertyIndex + ')';
        }

        public int hashCode() {
            int result = this.jsonName.hashCode();
            result = result * 31 + this.adapter.hashCode();
            result = result * 31 + this.property.hashCode();
            result = result * 31 + (this.parameter == null ? 0 : this.parameter.hashCode());
            result = result * 31 + Integer.hashCode(this.propertyIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)other;
            if (!Intrinsics.areEqual((Object)this.jsonName, (Object)binding.jsonName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.adapter, binding.adapter)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.property, binding.property)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parameter, (Object)binding.parameter)) {
                return false;
            }
            return this.propertyIndex == binding.propertyIndex;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016R(\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/squareup/moshi/kotlin/reflect/KotlinJsonAdapter$IndexedParameterMap;", "Lkotlin/collections/AbstractMutableMap;", "Lkotlin/reflect/KParameter;", "", "parameterKeys", "", "parameterValues", "", "(Ljava/util/List;[Ljava/lang/Object;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "[Ljava/lang/Object;", "containsKey", "", "key", "get", "put", "value", "reflect"})
    public static final class IndexedParameterMap
    extends AbstractMutableMap<KParameter, Object> {
        @NotNull
        private final List<KParameter> parameterKeys;
        @NotNull
        private final Object[] parameterValues;

        public IndexedParameterMap(@NotNull List<? extends KParameter> parameterKeys, @NotNull Object[] parameterValues) {
            Intrinsics.checkNotNullParameter(parameterKeys, (String)"parameterKeys");
            Intrinsics.checkNotNullParameter((Object)parameterValues, (String)"parameterValues");
            this.parameterKeys = parameterKeys;
            this.parameterValues = parameterValues;
        }

        @Nullable
        public Object put(@NotNull KParameter key, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<Map.Entry<KParameter, Object>> getEntries() {
            void var3_3;
            void $this$filterTo$iv;
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this.parameterKeys;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void value;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KParameter kParameter = (KParameter)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AbstractMap.SimpleEntry<void, Object>(value, this.parameterValues[index]));
            }
            List allPossibleEntries = (List)destination$iv$iv;
            $this$mapIndexed$iv = allPossibleEntries;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                AbstractMap.SimpleEntry it = (AbstractMap.SimpleEntry)element$iv;
                boolean bl = false;
                if (!(it.getValue() != KotlinJsonAdapterKt.access$getABSENT_VALUE$p())) continue;
                destination$iv.add(element$iv);
            }
            return (Set)var3_3;
        }

        public boolean containsKey(@NotNull KParameter key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.parameterValues[key.getIndex()] != KotlinJsonAdapterKt.access$getABSENT_VALUE$p();
        }

        @Nullable
        public Object get(@NotNull KParameter key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.parameterValues[key.getIndex()];
            return value != KotlinJsonAdapterKt.access$getABSENT_VALUE$p() ? value : null;
        }
    }
}

