/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import dagger.internal.BindingsGroup;
import dagger.internal.Linker;
import dagger.internal.ModuleAdapter;
import dagger.internal.ProvidesBinding;
import dagger.internal.SetBinding;
import dagger.internal.codegen.AdapterJavadocs;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
public final class ModuleAdapterProcessor
extends AbstractProcessor {
    private static final List<String> INVALID_RETURN_TYPES = Arrays.asList(Provider.class.getCanonicalName(), Lazy.class.getCanonicalName());
    private final LinkedHashMap<String, List<ExecutableElement>> remainingTypes = new LinkedHashMap();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        this.remainingTypes.putAll(this.providerMethodsByClass(env));
        Iterator<String> i = this.remainingTypes.keySet().iterator();
        while (i.hasNext()) {
            String typeName = i.next();
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(typeName);
            List<ExecutableElement> providesTypes = this.remainingTypes.get(typeName);
            try {
                Map<String, Object> parsedAnnotation = Util.getAnnotation(Module.class, type);
                if (parsedAnnotation == null) {
                    this.error(type + " has @Provides methods but no @Module annotation", type);
                    continue;
                }
                JavaFile javaFile = this.generateModuleAdapter(type, parsedAnnotation, providesTypes);
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (Util.CodeGenerationIncompleteException e) {
                continue;
            }
            catch (IOException e) {
                this.error("Code gen failed: " + e, type);
            }
            i.remove();
        }
        if (env.processingOver() && this.remainingTypes.size() > 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find types required by provides methods for " + this.remainingTypes.keySet());
        }
        return false;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    private Map<String, List<ExecutableElement>> providerMethodsByClass(RoundEnvironment env) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        HashMap<String, List<ExecutableElement>> result = new HashMap<String, List<ExecutableElement>>();
        block3: for (Element element : this.findProvidesMethods(env)) {
            ArrayList<ExecutableElement> methods;
            switch (element.getEnclosingElement().getKind()) {
                case CLASS: {
                    break;
                }
                default: {
                    this.error("Unexpected @Provides on " + Util.elementToString(element), element);
                    continue block3;
                }
            }
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            Set<Modifier> typeModifiers = typeElement.getModifiers();
            if (typeModifiers.contains((Object)Modifier.PRIVATE) || typeModifiers.contains((Object)Modifier.ABSTRACT)) {
                this.error("Classes declaring @Provides methods must not be private or abstract: " + typeElement.getQualifiedName(), typeElement);
                continue;
            }
            Set<Modifier> methodModifiers = element.getModifiers();
            if (methodModifiers.contains((Object)Modifier.PRIVATE) || methodModifiers.contains((Object)Modifier.ABSTRACT) || methodModifiers.contains((Object)Modifier.STATIC)) {
                this.error("@Provides methods must not be private, abstract or static: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            ExecutableElement providerMethodAsExecutable = (ExecutableElement)element;
            if (!providerMethodAsExecutable.getThrownTypes().isEmpty()) {
                this.error("@Provides methods must not have a throws clause: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            TypeMirror returnType = types.erasure(providerMethodAsExecutable.getReturnType());
            if (!returnType.getKind().equals((Object)TypeKind.ERROR)) {
                for (String invalidTypeName : INVALID_RETURN_TYPES) {
                    TypeElement invalidTypeElement = elementUtils.getTypeElement(invalidTypeName);
                    if (invalidTypeElement == null || !types.isSameType(returnType, types.erasure(invalidTypeElement.asType()))) continue;
                    this.error(String.format("@Provides method must not return %s directly: %s.%s", invalidTypeElement, typeElement.getQualifiedName(), element), element);
                    continue block3;
                }
            }
            if ((methods = (ArrayList<ExecutableElement>)result.get(typeElement.getQualifiedName().toString())) == null) {
                methods = new ArrayList<ExecutableElement>();
                result.put(typeElement.getQualifiedName().toString(), methods);
            }
            methods.add(providerMethodAsExecutable);
        }
        TypeMirror objectType = elementUtils.getTypeElement("java.lang.Object").asType();
        for (Element element : env.getElementsAnnotatedWith(Module.class)) {
            String moduleName;
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                this.error("Modules must be classes: " + Util.elementToString(element), element);
                continue;
            }
            TypeElement moduleType = (TypeElement)element;
            if (!types.isSameType(moduleType.getSuperclass(), objectType)) {
                this.error("Modules must not extend from other classes: " + Util.elementToString(element), element);
            }
            if (result.containsKey(moduleName = moduleType.getQualifiedName().toString())) continue;
            result.put(moduleName, new ArrayList());
        }
        return result;
    }

    private Set<? extends Element> findProvidesMethods(RoundEnvironment env) {
        LinkedHashSet<? extends Element> result = new LinkedHashSet<Element>();
        result.addAll(env.getElementsAnnotatedWith(Provides.class));
        return result;
    }

    private JavaFile generateModuleAdapter(TypeElement type, Map<String, Object> module, List<ExecutableElement> providerMethods) {
        List<Object> duplicateIncludes;
        Object[] staticInjections = (Object[])module.get("staticInjections");
        Object[] injects = (Object[])module.get("injects");
        Object[] includes = (Object[])module.get("includes");
        boolean overrides = (Boolean)module.get("overrides");
        boolean complete = (Boolean)module.get("complete");
        boolean library = (Boolean)module.get("library");
        List<Object> duplicateInjects = ModuleAdapterProcessor.extractDuplicates(injects);
        if (!duplicateInjects.isEmpty()) {
            this.error("'injects' list contains duplicate entries: " + duplicateInjects, type);
        }
        if (!(duplicateIncludes = ModuleAdapterProcessor.extractDuplicates(includes)).isEmpty()) {
            this.error("'includes' list contains duplicate entries: " + duplicateIncludes, type);
        }
        ClassName moduleClassName = ClassName.get((TypeElement)type);
        ClassName adapterClassName = Util.adapterName(moduleClassName, "$$ModuleAdapter");
        TypeSpec.Builder adapterBuilder = TypeSpec.classBuilder((String)adapterClassName.simpleName()).addOriginatingElement((Element)type).addJavadoc("A manager of modules and provides adapters allowing for proper linking and\ninstance provision of types served by {@code @$T} methods.\n", new Object[]{Provides.class}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ModuleAdapter.class), (TypeName[])new TypeName[]{moduleClassName})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        adapterBuilder.addField(FieldSpec.builder(String[].class, (String)"INJECTS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{this.injectsInitializer(injects)}).build());
        adapterBuilder.addField(FieldSpec.builder((TypeName)Util.ARRAY_OF_CLASS, (String)"STATIC_INJECTIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{this.staticInjectionsInitializer(staticInjections)}).build());
        adapterBuilder.addField(FieldSpec.builder((TypeName)Util.ARRAY_OF_CLASS, (String)"INCLUDES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{this.includesInitializer(type, includes)}).build());
        adapterBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class, INJECTS, STATIC_INJECTIONS, $L /*overrides*/, INCLUDES, $L /*complete*/, $L /*library*/)", new Object[]{type.asType(), overrides, complete, library}).build());
        ExecutableElement noArgsConstructor = Util.getNoArgsConstructor(type);
        if (noArgsConstructor != null && Util.isCallableConstructor(noArgsConstructor)) {
            adapterBuilder.addMethod(MethodSpec.methodBuilder((String)"newModule").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)moduleClassName).addStatement("return new $T()", new Object[]{type.asType()}).build());
        }
        LinkedHashMap<ExecutableElement, ClassName> methodToClassName = new LinkedHashMap<ExecutableElement, ClassName>();
        LinkedHashMap<String, AtomicInteger> methodNameToNextId = new LinkedHashMap<String, AtomicInteger>();
        if (!providerMethods.isEmpty()) {
            MethodSpec.Builder getBindings = MethodSpec.methodBuilder((String)"getBindings").addJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(BindingsGroup.class, "bindings", new Modifier[0]).addParameter((TypeName)moduleClassName, "module", new Modifier[0]);
            block5: for (ExecutableElement providerMethod : providerMethods) {
                Provides provides = providerMethod.getAnnotation(Provides.class);
                switch (provides.type()) {
                    case UNIQUE: {
                        getBindings.addStatement("bindings.contributeProvidesBinding($S, new $T(module))", new Object[]{GeneratorKeys.get(providerMethod), this.bindingClassName(adapterClassName, providerMethod, methodToClassName, methodNameToNextId)});
                        continue block5;
                    }
                    case SET: {
                        getBindings.addStatement("$T.add(bindings, $S, new $T(module))", new Object[]{SetBinding.class, GeneratorKeys.getSetKey(providerMethod), this.bindingClassName(adapterClassName, providerMethod, methodToClassName, methodNameToNextId)});
                        continue block5;
                    }
                    case SET_VALUES: {
                        getBindings.addStatement("$T.add(bindings, $S, new $T(module))", new Object[]{SetBinding.class, GeneratorKeys.get(providerMethod), this.bindingClassName(adapterClassName, providerMethod, methodToClassName, methodNameToNextId)});
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown @Provides type " + provides.type()));
            }
            adapterBuilder.addMethod(getBindings.build());
        }
        for (ExecutableElement providerMethod : providerMethods) {
            adapterBuilder.addType(this.generateProvidesAdapter(moduleClassName, adapterClassName, providerMethod, methodToClassName, methodNameToNextId, library));
        }
        return JavaFile.builder((String)adapterClassName.packageName(), (TypeSpec)adapterBuilder.build()).addFileComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]).build();
    }

    private static List<Object> extractDuplicates(Object[] items) {
        List<Object> itemsList = Arrays.asList(items);
        ArrayList<Object> duplicateItems = new ArrayList<Object>(itemsList);
        for (Object e : new LinkedHashSet<Object>(itemsList)) {
            duplicateItems.remove(e);
        }
        return duplicateItems;
    }

    private CodeBlock injectsInitializer(Object[] injects) {
        CodeBlock.Builder result = CodeBlock.builder().add("{ ", new Object[0]);
        for (Object injectableType : injects) {
            TypeMirror typeMirror = (TypeMirror)injectableType;
            String key = Util.isInterface(typeMirror) ? GeneratorKeys.get(typeMirror) : GeneratorKeys.rawMembersKey(typeMirror);
            result.add("$S, ", new Object[]{key});
        }
        result.add("}", new Object[0]);
        return result.build();
    }

    private CodeBlock staticInjectionsInitializer(Object[] staticInjections) {
        CodeBlock.Builder result = CodeBlock.builder().add("{ ", new Object[0]);
        for (Object staticInjection : staticInjections) {
            result.add("$T.class, ", new Object[]{staticInjection});
        }
        result.add("}", new Object[0]);
        return result.build();
    }

    private CodeBlock includesInitializer(TypeElement type, Object[] includes) {
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("{ ", new Object[0]);
        for (Object include : includes) {
            if (!(include instanceof TypeMirror)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unexpected value: " + include + " in includes of " + type, type);
                continue;
            }
            TypeMirror typeMirror = (TypeMirror)include;
            result.add("$T.class, ", new Object[]{typeMirror});
        }
        result.add("}", new Object[0]);
        return result.build();
    }

    private ClassName bindingClassName(ClassName adapterName, ExecutableElement providerMethod, Map<ExecutableElement, ClassName> methodToClassName, Map<String, AtomicInteger> methodNameToNextId) {
        ClassName className = methodToClassName.get(providerMethod);
        if (className != null) {
            return className;
        }
        String methodName = providerMethod.getSimpleName().toString();
        String suffix = "";
        AtomicInteger id = methodNameToNextId.get(methodName);
        if (id == null) {
            methodNameToNextId.put(methodName, new AtomicInteger(2));
        } else {
            suffix = id.toString();
            id.incrementAndGet();
        }
        String uppercaseMethodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        className = adapterName.nestedClass(uppercaseMethodName + "ProvidesAdapter" + suffix);
        methodToClassName.put(providerMethod, className);
        return className;
    }

    private TypeSpec generateProvidesAdapter(ClassName moduleClassName, ClassName adapterName, ExecutableElement providerMethod, Map<ExecutableElement, ClassName> methodToClassName, Map<String, AtomicInteger> methodNameToNextId, boolean library) {
        String methodName = providerMethod.getSimpleName().toString();
        TypeMirror moduleType = providerMethod.getEnclosingElement().asType();
        ClassName className = this.bindingClassName(adapterName, providerMethod, methodToClassName, methodNameToNextId);
        TypeName returnType = Util.injectableType(providerMethod.getReturnType());
        List<? extends VariableElement> parameters = providerMethod.getParameters();
        boolean dependent = !parameters.isEmpty();
        TypeSpec.Builder result = TypeSpec.classBuilder((String)className.simpleName()).addJavadoc("$L", new Object[]{AdapterJavadocs.bindingTypeDocs(returnType, false, false, dependent)}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ProvidesBinding.class), (TypeName[])new TypeName[]{returnType}));
        result.addField((TypeName)moduleClassName, "module", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        for (Element element : parameters) {
            result.addField((TypeName)Util.bindingOf(element.asType()), this.parameterName(element), new Modifier[]{Modifier.PRIVATE});
        }
        boolean singleton = providerMethod.getAnnotation(Singleton.class) != null;
        String string = GeneratorKeys.get(providerMethod);
        result.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)moduleClassName, "module", new Modifier[0]).addStatement("super($S, $L, $S, $S)", new Object[]{string, singleton ? "IS_SINGLETON" : "NOT_SINGLETON", Util.typeToString(moduleType), methodName}).addStatement("this.module = module", new Object[0]).addStatement("setLibrary($L)", new Object[]{library}).build());
        if (dependent) {
            MethodSpec.Builder attachBuilder = MethodSpec.methodBuilder((String)"attach").addJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.\n", new Object[0]).addAnnotation(Override.class).addAnnotation(Util.UNCHECKED).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Linker.class, "linker", new Modifier[0]);
            for (VariableElement variableElement : parameters) {
                String string2 = GeneratorKeys.get(variableElement);
                attachBuilder.addStatement("$N = ($T) linker.requestBinding($S, $T.class, getClass().getClassLoader())", new Object[]{this.parameterName(variableElement), Util.bindingOf(variableElement.asType()), string2, moduleClassName});
            }
            result.addMethod(attachBuilder.build());
            MethodSpec.Builder getDependenciesBuilder = MethodSpec.methodBuilder((String)"getDependencies").addJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Util.SET_OF_BINDINGS, "getBindings", new Modifier[0]).addParameter(Util.SET_OF_BINDINGS, "injectMembersBindings", new Modifier[0]);
            for (Element element : parameters) {
                getDependenciesBuilder.addStatement("getBindings.add($N)", new Object[]{this.parameterName(element)});
            }
            result.addMethod(getDependenciesBuilder.build());
        }
        MethodSpec.Builder getBuilder = MethodSpec.methodBuilder((String)"get").addJavadoc("Returns the fully provisioned instance satisfying the contract for\n{@code Provider<$T>}.\n", new Object[]{returnType}).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addCode("return module.$N(", new Object[]{methodName});
        boolean first = true;
        for (Element element : parameters) {
            if (!first) {
                getBuilder.addCode(", ", new Object[0]);
            }
            getBuilder.addCode("$N.get()", new Object[]{this.parameterName(element)});
            first = false;
        }
        getBuilder.addCode(");\n", new Object[0]);
        result.addMethod(getBuilder.build());
        return result.build();
    }

    private String parameterName(Element parameter) {
        if (parameter.getSimpleName().contentEquals("module")) {
            return "parameter_" + parameter.getSimpleName().toString();
        }
        return parameter.getSimpleName().toString();
    }
}

