/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.text;

import com.squarespace.compiler.match.Recognizers;
import com.squarespace.compiler.text.DefaultCharClassifier;

public class Scanner {
    private final CharSequence raw;

    public Scanner(CharSequence raw) {
        this.raw = raw;
    }

    public Stream stream() {
        return new Stream();
    }

    public class Stream {
        public int pos;
        public int end;

        public Stream() {
            this(0, this$0.raw.length());
        }

        public Stream(int pos, int end) {
            this.set(pos, end);
        }

        public Stream copy() {
            return new Stream(this.pos, this.end);
        }

        public CharSequence token() {
            return Scanner.this.raw.subSequence(this.pos, this.end);
        }

        public CharSequence raw() {
            return Scanner.this.raw;
        }

        public void set(int pos, int end) {
            this.pos = pos;
            this.end = end;
        }

        public void setFrom(Stream other) {
            this.pos = other.pos;
            this.end = other.end;
        }

        public void jump(Stream other) {
            this.pos = other.end;
        }

        public char peek() {
            return this.pos < this.end ? Scanner.this.raw.charAt(this.pos) : (char)'\uffff';
        }

        public int find(char expected) {
            for (int s = this.pos; s < this.end; ++s) {
                if (Scanner.this.raw.charAt(s) != expected) continue;
                return s;
            }
            return -1;
        }

        public char seek() {
            char ch = this.peek();
            ++this.pos;
            return ch;
        }

        public boolean seek(Recognizers.Recognizer matcher, Stream other) {
            int r = matcher.match(Scanner.this.raw, this.pos, this.end);
            if (r != -1) {
                other.set(this.pos, r);
                return true;
            }
            return false;
        }

        public void skipWs() {
            while (this.pos < this.end && DefaultCharClassifier.whitespace(Scanner.this.raw.charAt(this.pos))) {
                ++this.pos;
            }
        }

        public boolean skip(Recognizers.Recognizer pattern) {
            int e = pattern.match(Scanner.this.raw, this.pos, this.end);
            if (e == -1) {
                return false;
            }
            this.pos = e;
            return true;
        }

        public boolean seekBounds(Stream other, char left, char right) {
            int depth = 0;
            int start = -1;
            while (this.pos < this.end) {
                char ch = Scanner.this.raw.charAt(this.pos);
                if (ch == left) {
                    if (depth == 0) {
                        start = this.pos;
                    }
                    ++depth;
                } else if (ch == right && start != -1 && --depth == 0) {
                    ++this.pos;
                    other.set(start, this.pos);
                    return true;
                }
                ++this.pos;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Stream) {
                Stream other = (Stream)obj;
                return this.equalsCharacters(other.raw(), other.pos, other.end);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode() not supported");
        }

        public String toString() {
            return Scanner.this.raw.subSequence(this.pos, this.end).toString();
        }

        public boolean equalsCharacters(CharSequence other, int bs, int be) {
            int ae = this.end;
            int as = this.pos;
            int len = ae - as;
            if (len != be - bs) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (Scanner.this.raw.charAt(as + i) == other.charAt(bs + i)) continue;
                return false;
            }
            return true;
        }
    }
}

