/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.text;

import com.squarespace.compiler.text.CharClassifier;
import com.squarespace.compiler.text.Chars;
import com.squarespace.compiler.text.DefaultCharClassifier;

public class EncodeUtils {
    private static final CharClassifier CLASSIFIER = new DefaultCharClassifier();
    private static final CharPredicate ENCODE_URI = new CharPredicate(){

        @Override
        public boolean member(char ch) {
            return CLASSIFIER.isMember(ch, 455);
        }
    };
    private static final CharPredicate ENCODE_URI_COMPONENT = new CharPredicate(){

        @Override
        public boolean member(char ch) {
            return CLASSIFIER.isMember(ch, 263);
        }
    };
    private static final CharPredicate ESCAPE = new CharPredicate(){

        @Override
        public boolean member(char ch) {
            return CLASSIFIER.isMember(ch, 519);
        }
    };

    private EncodeUtils() {
    }

    public static String encodeURI(String uri) {
        return EncodeUtils.encodeChars(uri, ENCODE_URI);
    }

    public static String encodeURIComponent(String uri) {
        return EncodeUtils.encodeChars(uri, ENCODE_URI_COMPONENT);
    }

    public static String escape(String uri) {
        return EncodeUtils.encodeChars(uri, ESCAPE);
    }

    private static String encodeChars(String uri, CharPredicate predicate) {
        StringBuilder buf = new StringBuilder();
        int size = uri.length();
        for (int i = 0; i < size; ++i) {
            char ch = uri.charAt(i);
            if (ch >= '\u0100') {
                buf.append("%u");
                buf.append(Chars.hexchar(ch >> 12));
                buf.append(Chars.hexchar(ch >> 8 & 0xF));
                buf.append(Chars.hexchar(ch >> 4 & 0xF));
                buf.append(Chars.hexchar(ch & 0xF));
                continue;
            }
            if (predicate.member(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append('%');
            buf.append(Chars.hexchar(ch >> 4));
            buf.append(Chars.hexchar(ch & 0xF));
        }
        return buf.toString();
    }

    private static interface CharPredicate {
        public boolean member(char var1);
    }
}

