/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.text;

import com.squarespace.compiler.text.CharClassifier;

public class DefaultCharClassifier
implements CharClassifier {
    public static final int NONE = 0;
    public static final int DIGIT = 1;
    public static final int LOWERCASE = 2;
    public static final int UPPERCASE = 4;
    public static final int NONASCII = 8;
    public static final int NONPRINTABLE = 16;
    public static final int HEXDIGIT = 32;
    public static final int NUMBER_SIGN = 64;
    public static final int URI_RESERVED = 128;
    public static final int URI_MARK = 256;
    public static final int ESCAPE_SYMS = 512;
    public static final int DASH = 1024;
    public static final int UNDERSCORE = 2048;
    private static final int LIMIT = 128;
    private static final int[] CHARACTER_CLASSES = new int[128];

    @Override
    public boolean isMember(char ch, int cls) {
        return ch < '\u0080' ? (CHARACTER_CLASSES[ch] & cls) > 0 : false;
    }

    public String membersOf(int cls) {
        StringBuilder buf = new StringBuilder();
        for (char ch = '\u0000'; ch < '\u0080'; ch = (char)(ch + '\u0001')) {
            if ((CHARACTER_CLASSES[ch] & cls) <= 0) continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static boolean whitespace(char ch) {
        return ch == ' ' || ch >= '\t' && ch <= '\r' || ch == '\u00a0' || ch == '\u1680' || ch == '\u180e' || ch >= '\u2000' && ch <= '\u200a' || ch == '\u2028' || ch == '\u2029' || ch == '\u202f' || ch == '\u205f' || ch == '\u3000' || ch == '\ufeff';
    }

    private static int classify(char ch) {
        switch (ch) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                return 16;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return 16;
            }
            case '!': {
                return 256;
            }
            case '#': {
                return 64;
            }
            case '$': {
                return 128;
            }
            case '%': {
                return 0;
            }
            case '&': {
                return 128;
            }
            case '\'': 
            case '(': 
            case ')': {
                return 256;
            }
            case '*': {
                return 768;
            }
            case '+': {
                return 640;
            }
            case ',': {
                return 128;
            }
            case '-': {
                return 1792;
            }
            case '.': {
                return 768;
            }
            case '/': {
                return 640;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return 33;
            }
            case ':': 
            case ';': 
            case '=': {
                return 128;
            }
            case '>': {
                return 0;
            }
            case '?': {
                return 128;
            }
            case '@': {
                return 640;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return 36;
            }
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                return 4;
            }
            case '_': {
                return 2816;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return 34;
            }
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return 2;
            }
            case '{': 
            case '|': 
            case '}': {
                return 0;
            }
            case '~': {
                return 256;
            }
        }
        return ch < '\u00a0' ? 0 : 8;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            DefaultCharClassifier.CHARACTER_CLASSES[i] = DefaultCharClassifier.classify((char)i);
        }
    }
}

