/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.parse;

import com.squarespace.compiler.parse.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Struct<T extends Enum<T>>
extends Node<T> {
    private List<Node<T>> nodes = new ArrayList<Node<T>>();

    public Struct(T type) {
        super(type);
    }

    public Struct(T type, List<? extends Node<T>> nodes) {
        this(type);
        this.nodes.addAll(nodes);
    }

    @SafeVarargs
    public <N extends Node<T>> Struct(T type, N ... nodes) {
        this(type, Arrays.asList(nodes));
    }

    public void add(Node<T> node) {
        this.nodes.add(node);
    }

    @SafeVarargs
    public final Struct<T> addNotNull(Node<T> ... nodes) {
        for (Node<T> n : nodes) {
            if (n == null) continue;
            this.nodes.add(n);
        }
        return this;
    }

    public List<Node<T>> nodes() {
        return this.nodes;
    }

    @SafeVarargs
    public static <T extends Enum<T>> Node<T> struct(T type, Node<T> ... nodes) {
        return new Struct<T>(type, Arrays.asList(nodes));
    }

    public static <T extends Enum<T>> Node<T> struct(T type, List<? extends Node<T>> nodes) {
        return new Struct<T>(type, nodes);
    }

    public int hashCode() {
        return Objects.hash(this.type(), this.nodes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Struct) {
            Struct other = (Struct)obj;
            return ((Enum)this.type()).equals(other.type()) && this.nodes.equals(other.nodes);
        }
        return false;
    }
}

