/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.parse;

import com.squarespace.compiler.parse.Atom;
import com.squarespace.compiler.parse.Node;
import com.squarespace.compiler.parse.Struct;
import java.util.List;

public class Printer {
    private static final int INCR = 2;

    public static <T extends Enum<T>> void print(Node<T> node, StringBuilder buf) {
        Printer.print(node, buf, 0);
    }

    private static <T extends Enum<T>> void print(Node<T> node, StringBuilder buf, int depth) {
        buf.append('(').append(node.type()).append(' ');
        if (node instanceof Struct) {
            ++depth;
            buf.append('\n');
            Struct tuple = (Struct)node;
            List nodes = tuple.nodes();
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Printer.indent(buf, depth);
                Printer.print(nodes.get(i), buf, depth);
                buf.append('\n');
            }
            Printer.indent(buf, --depth);
        } else {
            Atom atom = (Atom)node;
            buf.append(atom.value());
        }
        buf.append(')');
    }

    private static void indent(StringBuilder buf, int size) {
        for (int i = 0; i < size * 2; ++i) {
            buf.append(' ');
        }
    }
}

