/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.parse;

import com.squarespace.compiler.common.Maybe;
import com.squarespace.compiler.match.Recognizers;
import com.squarespace.compiler.parse.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public interface Parser<T> {
    public Maybe<Pair<T, CharSequence>> parse(CharSequence var1);

    public static Parser<CharSequence> matcher(Recognizers.Recognizer pattern) {
        return s -> {
            int length = s.length();
            int end = pattern.match(s, 0, length);
            return end == -1 ? Maybe.nothing() : Maybe.just(Pair.pair(s.subSequence(0, end), s.subSequence(end, length)));
        };
    }

    default public <R> Parser<T> prefix(Parser<R> parser) {
        return parser.flatMap(o -> this);
    }

    default public Parser<T> suffix(Parser<?> parser) {
        return this.flatMap(t -> parser.map(o -> t));
    }

    default public <R> Parser<R> map(Function<T, R> f) {
        return s -> this.parse(s).map(p -> Pair.pair(f.apply(p._1), p._2));
    }

    default public <R> Parser<R> flatMap(Function<T, Parser<R>> f) {
        return s -> this.parse(s).flatMap((T p) -> ((Parser)f.apply(p._1)).parse((CharSequence)p._2));
    }

    default public Parser<List<T>> zeroOrMore() {
        return this.oneOrMore().orDefault(Collections.emptyList());
    }

    default public Parser<List<T>> oneOrMore() {
        return this.flatMap(x -> this.zeroOrMore().map(xs -> Parser.cons(x, xs)));
    }

    default public Parser<T> or(Parser<T> alt) {
        return s -> this.parse(s).orElse(() -> alt.parse(s));
    }

    default public Parser<T> orDefault(T v) {
        return s -> this.parse(s).orElse(() -> Maybe.just(Pair.pair(v, s)));
    }

    default public <R> Parser<List<T>> separated(Parser<R> delimiter) {
        Parser skipped = this.prefix(delimiter);
        return this.flatMap(t -> skipped.zeroOrMore().map(ts -> Parser.cons(t, ts)));
    }

    public static <T> List<T> cons(T x, List<T> xs) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(x);
        result.addAll(xs);
        return result;
    }
}

