/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.parse;

import com.squarespace.compiler.parse.Node;
import java.util.Objects;

public class Atom<T extends Enum<T>>
extends Node<T> {
    private final Object value;
    private final int hashCode;

    public Atom(T type, Object value) {
        super(type);
        this.value = value;
        this.hashCode = Objects.hash(type, value);
    }

    public Object value() {
        return this.value;
    }

    public static <T extends Enum<T>> Node<T> atom(T type, Object value) {
        return new Atom<T>(type, value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Atom) {
            Atom other = (Atom)obj;
            return ((Enum)this.type()).equals(other.type()) && Objects.equals(this.value, other.value);
        }
        return false;
    }
}

