/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.match;

import com.squarespace.compiler.text.CharClassifier;
import com.squarespace.compiler.text.DefaultCharClassifier;

public class Recognizers {
    public static final int FAIL = -1;
    private static final Recognizer ANY = new Any();
    private static final Recognizer WHITESPACE = new Whitespace(false);
    private static final Recognizer NOT_WHITESPACE = new Whitespace(true);
    private static final CharClassifier CLASSIFIER = new DefaultCharClassifier();

    private Recognizers() {
    }

    public static Recognizer any() {
        return ANY;
    }

    public static Recognizer cardinality(Recognizer pattern, int minimum, int maximum) {
        return new Cardinality(pattern, minimum, maximum);
    }

    public static Recognizer characters(char first, char ... characters) {
        return new Characters(false, first, characters);
    }

    public static Recognizer charClass(int bitmask, CharClassifier classifier) {
        return new CharacterClass(bitmask, classifier);
    }

    public static Recognizer charRange(char start, char end) {
        return new CharacterRange(start, end);
    }

    public static Recognizer choice(Recognizer ... patterns) {
        return new Choice(patterns);
    }

    public static Recognizer decimal() {
        return new Decimal();
    }

    public static Recognizer digit() {
        return Recognizers.charClass(1, CLASSIFIER);
    }

    public static Recognizer digits() {
        return Recognizers.oneOrMore(Recognizers.digit());
    }

    public static Recognizer hexdigit() {
        return Recognizers.charClass(32, CLASSIFIER);
    }

    public static Recognizer literal(String str) {
        return new Literal(str);
    }

    public static Recognizer lookAhead(Recognizer pattern) {
        return new LookAhead(pattern);
    }

    public static Recognizer oneOrMore(Recognizer pattern) {
        return new Plus(pattern);
    }

    public static Recognizer notAscii() {
        return Recognizers.notCharRange('\u0000', '\u009f');
    }

    public static Recognizer notCharacters(char first, char ... characters) {
        return new Characters(true, first, characters);
    }

    public static Recognizer notCharClass(int bitmask, CharClassifier classifier) {
        return new CharacterClass(bitmask, true, classifier);
    }

    public static Recognizer notCharRange(char start, char end) {
        return new CharacterRange(true, start, end);
    }

    public static Recognizer notHexdigit() {
        return Recognizers.notCharClass(32, CLASSIFIER);
    }

    public static Recognizer sequence(Recognizer ... patterns) {
        return new Sequence(patterns);
    }

    public static Recognizer whitespace() {
        return WHITESPACE;
    }

    public static Recognizer notWhitespace() {
        return NOT_WHITESPACE;
    }

    public static Recognizer word() {
        return Recognizers.charClass(2055, CLASSIFIER);
    }

    public static Recognizer worddash() {
        return Recognizers.charClass(3079, CLASSIFIER);
    }

    public static Recognizer zeroOrOne(Recognizer pattern) {
        return new QuestionMark(pattern);
    }

    public static Recognizer zeroOrMore(Recognizer pattern) {
        return new Star(pattern);
    }

    public static Recognizer zeroOrMore(Recognizer pattern, int limit) {
        return new Cardinality(pattern, limit);
    }

    public static interface Recognizer {
        public int match(CharSequence var1, int var2, int var3);
    }

    static class Whitespace
    implements Recognizer {
        private final boolean invert;

        Whitespace(boolean invert) {
            this.invert = invert;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            if (pos < length) {
                if (DefaultCharClassifier.whitespace(seq.charAt(pos))) {
                    return this.invert ? -1 : pos + 1;
                }
                return this.invert ? pos + 1 : -1;
            }
            return -1;
        }
    }

    static class Star
    extends Cardinality {
        Star(Recognizer pattern) {
            super(pattern, 0, 0);
        }
    }

    static class Sequence
    implements Recognizer {
        private final Recognizer[] patterns;

        Sequence(Recognizer[] patterns) {
            this.patterns = patterns;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            int result = 0;
            for (Recognizer pattern : this.patterns) {
                if ((pos = pattern.match(seq, pos, length)) == -1) {
                    return -1;
                }
                result = pos;
            }
            return result;
        }
    }

    static class QuestionMark
    extends Cardinality {
        QuestionMark(Recognizer pattern) {
            super(pattern, 0, 1);
        }
    }

    static class Plus
    extends Cardinality {
        Plus(Recognizer pattern) {
            super(pattern, 1, 0);
        }
    }

    static class LookAhead
    implements Recognizer {
        private final Recognizer pattern;

        LookAhead(Recognizer pattern) {
            this.pattern = pattern;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            return this.pattern.match(seq, pos, length) != -1 ? pos : -1;
        }
    }

    static class Literal
    implements Recognizer {
        private final String literal;
        private final int literalLength;

        Literal(String value) {
            this.literal = value;
            this.literalLength = this.literal.length();
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            if (this.literalLength <= length - pos) {
                int i = 0;
                while (i < this.literalLength) {
                    if (this.literal.charAt(i) != seq.charAt(pos)) {
                        return -1;
                    }
                    ++i;
                    ++pos;
                }
                return pos;
            }
            return -1;
        }
    }

    static class Decimal
    implements Recognizer {
        Decimal() {
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            int save = pos;
            int res = -1;
            boolean dot = false;
            while (pos < length) {
                char ch = seq.charAt(pos);
                if (ch == '.') {
                    if (dot) break;
                    dot = true;
                } else if (!CLASSIFIER.isMember(ch, 1)) break;
                res = ++pos;
            }
            return dot && save == pos - 1 ? -1 : res;
        }
    }

    static class Choice
    implements Recognizer {
        private final Recognizer[] patterns;

        Choice(Recognizer[] patterns) {
            this.patterns = patterns;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            int save = -1;
            for (Recognizer pattern : this.patterns) {
                int res = pattern.match(seq, pos, length);
                if (res <= save) continue;
                save = Math.max(save, res);
            }
            return save;
        }
    }

    static class CharacterRange
    implements Recognizer {
        private final boolean invert;
        private final char start;
        private final char end;

        CharacterRange(char start, char end) {
            this(false, start, end);
        }

        CharacterRange(boolean invert, char start, char end) {
            this.invert = invert;
            this.start = start;
            this.end = end;
        }

        @Override
        public int match(CharSequence seq, int pos, int len) {
            if (pos < len) {
                char ch = seq.charAt(pos);
                boolean result = this.invert ? ch < this.start || ch > this.end : ch >= this.start && ch <= this.end;
                return result ? pos + 1 : -1;
            }
            return -1;
        }
    }

    static class CharacterClass
    implements Recognizer {
        private final int bitmask;
        private final boolean invert;
        private final CharClassifier classifier;

        CharacterClass(int charClass, CharClassifier classifier) {
            this(charClass, false, classifier);
        }

        CharacterClass(int charClass, boolean invert, CharClassifier classifier) {
            this.bitmask = charClass;
            this.invert = invert;
            this.classifier = classifier;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            if (pos < length) {
                boolean result = this.classifier.isMember(seq.charAt(pos), this.bitmask);
                return this.invert ? (result ? -1 : pos + 1) : (result ? pos + 1 : -1);
            }
            return -1;
        }
    }

    static class Characters
    implements Recognizer {
        private final boolean invert;
        private final char first;
        private final char[] chars;

        Characters(boolean invert, char first, char ... chars) {
            this.invert = invert;
            this.first = first;
            this.chars = chars;
        }

        @Override
        public int match(CharSequence seq, int pos, int len) {
            if (pos < len) {
                char actual = seq.charAt(pos);
                if (actual == this.first) {
                    return this.invert ? -1 : pos + 1;
                }
                for (char expected : this.chars) {
                    if (actual != expected) continue;
                    return this.invert ? -1 : pos + 1;
                }
                return this.invert ? pos + 1 : -1;
            }
            return -1;
        }
    }

    static class Cardinality
    implements Recognizer {
        private final Recognizer pattern;
        private final int start;
        private final int limit;

        Cardinality(Recognizer pattern, int limit) {
            this(pattern, 0, limit);
        }

        Cardinality(Recognizer pattern, int start, int limit) {
            this.pattern = pattern;
            this.start = start;
            this.limit = limit;
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            int result = pos;
            int count = 0;
            while ((pos = this.pattern.match(seq, pos, length)) != -1) {
                result = pos;
                if (++count != this.limit) continue;
            }
            return this.start > 0 ? (count < this.start ? -1 : result) : result;
        }
    }

    static class Any
    implements Recognizer {
        Any() {
        }

        @Override
        public int match(CharSequence seq, int pos, int length) {
            return pos < length ? pos + 1 : -1;
        }
    }
}

