/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.common;

public class StringView
implements CharSequence {
    private final String str;
    private final int start;
    private final int end;
    private int hashVal;
    private String repr;

    public StringView(String data) {
        this(data, 0, data.length());
    }

    public StringView(String str, int start, int end) {
        this.str = str;
        this.start = Math.max(start, 0);
        this.end = Math.min(end, str.length());
    }

    public String data() {
        return this.str;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public char lastChar() {
        return this.str.charAt(this.end - 1);
    }

    public StringView subview(int start0, int end0) {
        return new StringView(this.str, this.start + start0, this.start + end0);
    }

    public String repr() {
        if (this.repr == null) {
            this.repr = this.str.substring(this.start, this.end);
        }
        return this.repr;
    }

    @Override
    public String toString() {
        return this.repr();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringView)) {
            return false;
        }
        StringView other = (StringView)obj;
        int len = this.length();
        if (len != other.length()) {
            return false;
        }
        String s1 = this.str;
        String s2 = other.str;
        int start1 = this.start;
        for (int start2 = other.start; start1 < this.end && start2 < other.end; ++start1, ++start2) {
            if (s1.charAt(start1) == s2.charAt(start2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashVal == 0) {
            int h = 16777619;
            for (int i = this.start; i < this.end; ++i) {
                h = 31 * h + this.str.charAt(i);
            }
            if (h == 0) {
                ++h;
            }
            this.hashVal = h;
        }
        return this.hashVal;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.str.charAt(this.start + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subview(start, end);
    }
}

