/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.compiler.common;

import com.squarespace.compiler.common.Just;
import com.squarespace.compiler.common.Nothing;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Maybe<T> {
    public T get();

    public boolean isJust();

    default public boolean isNothing() {
        return !this.isJust();
    }

    public static <T> Maybe<T> nothing() {
        return Nothing.NOTHING;
    }

    public static <T> Maybe<T> just(T value) {
        return new Just<T>(value);
    }

    default public <R> Maybe<R> map(Function<T, R> f) {
        return this.isJust() ? Maybe.just(f.apply(this.get())) : Maybe.nothing();
    }

    default public <R> Maybe<R> flatMap(Function<T, Maybe<R>> f) {
        return this.isJust() ? f.apply(this.get()) : Maybe.nothing();
    }

    default public Maybe<T> orElse(Supplier<Maybe<T>> f) {
        return this.isJust() ? this : f.get();
    }
}

