/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.either;

import com.spencerwi.either.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class EitherCollectors<L, R>
implements Collector<Either<L, R>, EitherAccumulator<L, R>, Either<List<L>, List<R>>> {
    private final boolean leftBiased;

    public static <L, R> Collector<Either<L, R>, ?, Either<List<L>, List<R>>> toLeftBiased() {
        return new EitherCollectors<L, R>(true);
    }

    public static <L, R> Collector<Either<L, R>, ?, Either<List<L>, List<R>>> toRightBiased() {
        return new EitherCollectors<L, R>(false);
    }

    private EitherCollectors(boolean leftBiased) {
        this.leftBiased = leftBiased;
    }

    @Override
    public Supplier<EitherAccumulator<L, R>> supplier() {
        return () -> new EitherAccumulator(this.leftBiased);
    }

    @Override
    public BiConsumer<EitherAccumulator<L, R>, Either<L, R>> accumulator() {
        return EitherAccumulator::add;
    }

    @Override
    public BinaryOperator<EitherAccumulator<L, R>> combiner() {
        return EitherAccumulator::append;
    }

    @Override
    public Function<EitherAccumulator<L, R>, Either<List<L>, List<R>>> finisher() {
        return EitherAccumulator::finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT));
    }

    static class EitherAccumulator<L, R> {
        private final List<L> lefts;
        private final List<R> rights;
        private final boolean leftBiased;

        EitherAccumulator(boolean leftBiased) {
            this.leftBiased = leftBiased;
            this.lefts = new ArrayList<L>();
            this.rights = new ArrayList<R>();
        }

        void add(Either<L, R> e) {
            e.run(this.lefts::add, this.rights::add);
        }

        EitherAccumulator<L, R> append(EitherAccumulator<L, R> accumulator2) {
            this.lefts.addAll(accumulator2.lefts);
            this.rights.addAll(accumulator2.rights);
            return this;
        }

        Either<List<L>, List<R>> finisher() {
            if (this.leftBiased) {
                return !this.lefts.isEmpty() || this.rights.isEmpty() ? Either.left(this.lefts) : Either.right(this.rights);
            }
            return !this.rights.isEmpty() || this.lefts.isEmpty() ? Either.right(this.rights) : Either.left(this.lefts);
        }
    }
}

