/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.either;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> either(Supplier<L> leftSupplier, Supplier<R> rightSupplier) {
        R rightValue = rightSupplier.get();
        if (rightValue != null) {
            return Either.right(rightValue);
        }
        return Either.left(leftSupplier.get());
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public abstract L getLeft();

    public abstract R getRight();

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract <T> T fold(Function<L, T> var1, Function<R, T> var2);

    public abstract <T, U> Either<T, U> map(Function<L, T> var1, Function<R, U> var2);

    public abstract <T, U> Either<T, U> flatMap(Function<L, Either<T, U>> var1, Function<R, Either<T, U>> var2);

    public abstract void run(Consumer<L> var1, Consumer<R> var2);

    public <L2> Either<L2, R> mapLeft(Function<L, L2> transformLeft) {
        return this.map(transformLeft, Function.identity());
    }

    public <R2> Either<L, R2> mapRight(Function<R, R2> transformRight) {
        return this.map(Function.identity(), transformRight);
    }

    public abstract <L2> Either<L2, R> flatMapLeft(Function<L, Either<L2, R>> var1);

    public abstract <R2> Either<L, R2> flatMapRight(Function<R, Either<L, R2>> var1);

    public abstract <X extends Throwable> L getLeftOrElseThrow(Supplier<X> var1) throws X;

    public abstract <X extends Throwable> L getLeftOrElseThrow(Function<R, X> var1) throws X;

    public abstract <X extends Throwable> R getRightOrElseThrow(Supplier<X> var1) throws X;

    public abstract <X extends Throwable> R getRightOrElseThrow(Function<L, X> var1) throws X;

    public static class Left<L, R>
    extends Either<L, R> {
        protected L leftValue;

        private Left(L left) {
            this.leftValue = left;
        }

        @Override
        public L getLeft() {
            return this.leftValue;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("Tried to getRight from a Left");
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public <T> T fold(Function<L, T> transformLeft, Function<R, T> transformRight) {
            return transformLeft.apply(this.leftValue);
        }

        @Override
        public <T, U> Either<T, U> map(Function<L, T> transformLeft, Function<R, U> transformRight) {
            return Either.left(transformLeft.apply(this.leftValue));
        }

        @Override
        public <T, U> Either<T, U> flatMap(Function<L, Either<T, U>> eitherTransformLeft, Function<R, Either<T, U>> eitherTransformRight) {
            return eitherTransformLeft.apply(this.leftValue);
        }

        @Override
        public void run(Consumer<L> runLeft, Consumer<R> runRight) {
            runLeft.accept(this.leftValue);
        }

        @Override
        public <L2> Either<L2, R> flatMapLeft(Function<L, Either<L2, R>> transformLeft) {
            return transformLeft.apply(this.leftValue);
        }

        @Override
        public <R2> Either<L, R2> flatMapRight(Function<R, Either<L, R2>> transformRight) {
            return Either.left(this.leftValue);
        }

        @Override
        public <X extends Throwable> L getLeftOrElseThrow(Supplier<X> exceptionSupplier) throws X {
            return this.leftValue;
        }

        @Override
        public <X extends Throwable> L getLeftOrElseThrow(Function<R, X> rightToException) throws X {
            return this.leftValue;
        }

        @Override
        public <X extends Throwable> R getRightOrElseThrow(Supplier<X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public <X extends Throwable> R getRightOrElseThrow(Function<L, X> leftToException) throws X {
            throw (Throwable)leftToException.apply(this.leftValue);
        }

        public int hashCode() {
            return this.leftValue.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Left) {
                Left otherAsLeft = (Left)other;
                return this.leftValue.equals(otherAsLeft.leftValue);
            }
            return false;
        }
    }

    public static class Right<L, R>
    extends Either<L, R> {
        protected R rightValue;

        private Right(R right) {
            this.rightValue = right;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Tried to getLeft from a Right");
        }

        @Override
        public R getRight() {
            return this.rightValue;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public <T> T fold(Function<L, T> transformLeft, Function<R, T> transformRight) {
            return transformRight.apply(this.rightValue);
        }

        @Override
        public <T, U> Either<T, U> map(Function<L, T> transformLeft, Function<R, U> transformRight) {
            return Either.right(transformRight.apply(this.rightValue));
        }

        @Override
        public <T, U> Either<T, U> flatMap(Function<L, Either<T, U>> eitherTransformLeft, Function<R, Either<T, U>> eitherTransformRight) {
            return eitherTransformRight.apply(this.rightValue);
        }

        @Override
        public void run(Consumer<L> runLeft, Consumer<R> runRight) {
            runRight.accept(this.rightValue);
        }

        @Override
        public <L2> Either<L2, R> flatMapLeft(Function<L, Either<L2, R>> transformLeft) {
            return Either.right(this.rightValue);
        }

        @Override
        public <R2> Either<L, R2> flatMapRight(Function<R, Either<L, R2>> transformRight) {
            return transformRight.apply(this.rightValue);
        }

        @Override
        public <X extends Throwable> L getLeftOrElseThrow(Supplier<X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public <X extends Throwable> L getLeftOrElseThrow(Function<R, X> rightToException) throws X {
            throw (Throwable)rightToException.apply(this.rightValue);
        }

        @Override
        public <X extends Throwable> R getRightOrElseThrow(Supplier<X> exceptionSupplier) throws X {
            return this.rightValue;
        }

        @Override
        public <X extends Throwable> R getRightOrElseThrow(Function<L, X> leftToException) throws X {
            return this.rightValue;
        }

        public int hashCode() {
            return this.rightValue.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Right) {
                Right otherAsRight = (Right)other;
                return this.rightValue.equals(otherAsRight.rightValue);
            }
            return false;
        }
    }
}

