/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_kotlinc;

import com.sourcegraph.semanticdb_kotlinc.LineMap;
import com.sourcegraph.semanticdb_kotlinc.Semanticdb;
import com.sourcegraph.semanticdb_kotlinc.SemanticdbTextDocumentBuilder;
import com.sourcegraph.semanticdb_kotlinc.Symbol;
import com.sourcegraph.semanticdb_kotlinc.SymbolsCache;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.contracts.ExperimentalContracts;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerExtensionKt;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.NavigationItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0002J-\u0010'\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b(\u0010)J/\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006."}, d2={"Lcom/sourcegraph/semanticdb_kotlinc/SemanticdbTextDocumentBuilder;", "", "sourceroot", "Ljava/nio/file/Path;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineMap", "Lcom/sourcegraph/semanticdb_kotlinc/LineMap;", "cache", "Lcom/sourcegraph/semanticdb_kotlinc/SymbolsCache;", "(Ljava/nio/file/Path;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/sourcegraph/semanticdb_kotlinc/LineMap;Lcom/sourcegraph/semanticdb_kotlinc/SymbolsCache;)V", "occurrences", "", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolOccurrence;", "symbols", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolInformation;", "build", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$TextDocument;", "emitSemanticdbData", "", "symbol", "Lcom/sourcegraph/semanticdb_kotlinc/Symbol;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "role", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolOccurrence$Role;", "emitSemanticdbData-WnVtuAA", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolOccurrence$Role;)V", "semanticdbDocumentation", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$Documentation;", "semanticdbMD5", "", "semanticdbRange", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$Range;", "semanticdbURI", "stripKDocAsterisks", "kdoc", "symbolInformation", "symbolInformation-vWNn3L8", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolInformation;", "symbolOccurrence", "symbolOccurrence-vWNn3L8", "(Ljava/lang/String;Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolOccurrence$Role;)Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$SymbolOccurrence;", "Companion", "semanticdb-kotlinc"})
@ExperimentalContracts
public final class SemanticdbTextDocumentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path sourceroot;
    @NotNull
    private final KtFile file;
    @NotNull
    private final LineMap lineMap;
    @NotNull
    private final SymbolsCache cache;
    @NotNull
    private final List<Semanticdb.SymbolOccurrence> occurrences;
    @NotNull
    private final List<Semanticdb.SymbolInformation> symbols;

    public SemanticdbTextDocumentBuilder(@NotNull Path sourceroot, @NotNull KtFile file, @NotNull LineMap lineMap, @NotNull SymbolsCache cache) {
        Intrinsics.checkNotNullParameter(sourceroot, "sourceroot");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(lineMap, "lineMap");
        Intrinsics.checkNotNullParameter(cache, "cache");
        this.sourceroot = sourceroot;
        this.file = file;
        this.lineMap = lineMap;
        this.cache = cache;
        boolean bl = false;
        this.occurrences = new ArrayList();
        bl = false;
        this.symbols = new ArrayList();
    }

    @NotNull
    public final Semanticdb.TextDocument build() {
        boolean $i$f$TextDocument = false;
        Semanticdb.TextDocument.Builder builder = Semanticdb.TextDocument.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Semanticdb.TextDocument.Builder $this$build_u24lambda_u2d0 = builder;
        boolean bl3 = false;
        $this$build_u24lambda_u2d0.setText(this.file.getText());
        $this$build_u24lambda_u2d0.setUri(this.semanticdbURI());
        $this$build_u24lambda_u2d0.setMd5(this.semanticdbMD5());
        $this$build_u24lambda_u2d0.setSchema(Semanticdb.Schema.SEMANTICDB4);
        $this$build_u24lambda_u2d0.setLanguage(Semanticdb.Language.KOTLIN);
        $this$build_u24lambda_u2d0.addAllOccurrences((Iterable<? extends Semanticdb.SymbolOccurrence>)this.occurrences);
        $this$build_u24lambda_u2d0.addAllSymbols((Iterable<? extends Semanticdb.SymbolInformation>)this.symbols);
        Semanticdb.TextDocument textDocument = builder.build();
        Intrinsics.checkNotNullExpressionValue(textDocument, "newBuilder().apply(block).build()");
        return textDocument;
    }

    public final void emitSemanticdbData-WnVtuAA(@NotNull String symbol, @NotNull DeclarationDescriptor descriptor, @NotNull PsiElement element, @NotNull Semanticdb.SymbolOccurrence.Role role) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(role, "role");
        Semanticdb.SymbolOccurrence symbolOccurrence = this.symbolOccurrence-vWNn3L8(symbol, element, role);
        if (symbolOccurrence != null) {
            Semanticdb.SymbolOccurrence symbolOccurrence2 = symbolOccurrence;
            List<Semanticdb.SymbolOccurrence> list = this.occurrences;
            boolean bl = false;
            boolean bl2 = false;
            Semanticdb.SymbolOccurrence p0 = symbolOccurrence2;
            boolean bl3 = false;
            list.add(p0);
        }
        if (role == Semanticdb.SymbolOccurrence.Role.DEFINITION) {
            this.symbols.add(this.symbolInformation-vWNn3L8(symbol, descriptor, element));
        }
    }

    private final Semanticdb.SymbolInformation symbolInformation-vWNn3L8(String symbol, DeclarationDescriptor descriptor, PsiElement element) {
        Semanticdb.Language language;
        boolean $i$f$SymbolInformation = false;
        Semanticdb.SymbolInformation.Builder builder = Semanticdb.SymbolInformation.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Semanticdb.SymbolInformation.Builder $this$symbolInformation_vWNn3L8_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        $this$symbolInformation_vWNn3L8_u24lambda_u2d1.setSymbol(Symbol.toString-impl(symbol));
        $this$symbolInformation_vWNn3L8_u24lambda_u2d1.setDisplayName(SemanticdbTextDocumentBuilder.Companion.displayName(element));
        $this$symbolInformation_vWNn3L8_u24lambda_u2d1.setDocumentation(this.semanticdbDocumentation(descriptor));
        Language language2 = element.getLanguage();
        if (language2 instanceof KotlinLanguage) {
            language = Semanticdb.Language.KOTLIN;
        } else if (language2 instanceof JavaLanguage) {
            language = Semanticdb.Language.JAVA;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus("unexpected language ", element.getLanguage()));
        }
        $this$symbolInformation_vWNn3L8_u24lambda_u2d1.setLanguage(language);
        Semanticdb.SymbolInformation symbolInformation = builder.build();
        Intrinsics.checkNotNullExpressionValue(symbolInformation, "newBuilder().apply(block).build()");
        return symbolInformation;
    }

    private final Semanticdb.SymbolOccurrence symbolOccurrence-vWNn3L8(String symbol, PsiElement element, Semanticdb.SymbolOccurrence.Role role) {
        boolean $i$f$SymbolOccurrence = false;
        Semanticdb.SymbolOccurrence.Builder builder = Semanticdb.SymbolOccurrence.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Semanticdb.SymbolOccurrence.Builder $this$symbolOccurrence_vWNn3L8_u24lambda_u2d2 = builder;
        boolean bl3 = false;
        $this$symbolOccurrence_vWNn3L8_u24lambda_u2d2.setSymbol(Symbol.toString-impl(symbol));
        $this$symbolOccurrence_vWNn3L8_u24lambda_u2d2.setRole(role);
        $this$symbolOccurrence_vWNn3L8_u24lambda_u2d2.setRange(this.semanticdbRange(element));
        Semanticdb.SymbolOccurrence symbolOccurrence = builder.build();
        Intrinsics.checkNotNullExpressionValue(symbolOccurrence, "newBuilder().apply(block).build()");
        return symbolOccurrence;
    }

    private final Semanticdb.Range semanticdbRange(PsiElement element) {
        boolean $i$f$Range = false;
        Semanticdb.Range.Builder builder = Semanticdb.Range.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Semanticdb.Range.Builder $this$semanticdbRange_u24lambda_u2d3 = builder;
        boolean bl3 = false;
        $this$semanticdbRange_u24lambda_u2d3.setStartCharacter(this.lineMap.startCharacter(element) - 1);
        $this$semanticdbRange_u24lambda_u2d3.setStartLine(this.lineMap.lineNumber(element) - 1);
        $this$semanticdbRange_u24lambda_u2d3.setEndCharacter(this.lineMap.endCharacter(element) - 1);
        $this$semanticdbRange_u24lambda_u2d3.setEndLine(this.lineMap.lineNumber(element) - 1);
        Semanticdb.Range range = builder.build();
        Intrinsics.checkNotNullExpressionValue(range, "newBuilder().apply(block).build()");
        return range;
    }

    private final String semanticdbURI() {
        Path relative = this.sourceroot.relativize(Paths.get(this.file.getVirtualFilePath(), new String[0]));
        return ((Object)relative).toString();
    }

    private final String semanticdbMD5() {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = this.file.getText();
        Intrinsics.checkNotNullExpressionValue(string, "file.text");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getInstance(\"MD5\").diges\u2026.text.toByteArray(UTF_8))");
        return ArraysKt.joinToString$default(byArray2, (CharSequence)"", null, null, 0, null, (Function1)semanticdbMD5.1.INSTANCE, 30, null);
    }

    private final Semanticdb.Documentation semanticdbDocumentation(DeclarationDescriptor descriptor) {
        String string;
        boolean $i$f$Documentation = false;
        Semanticdb.Documentation.Builder builder = Semanticdb.Documentation.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Semanticdb.Documentation.Builder $this$semanticdbDocumentation_u24lambda_u2d4 = builder;
        boolean bl3 = false;
        $this$semanticdbDocumentation_u24lambda_u2d4.setFormat(Semanticdb.Documentation.Format.MARKDOWN);
        String signature2 = DescriptorRenderer.COMPACT_WITH_MODIFIERS.withOptions((Function1)semanticdbDocumentation.1.signature.1.INSTANCE).render(descriptor);
        DeclarationDescriptor declarationDescriptor = descriptor;
        String kdoc = declarationDescriptor instanceof DeclarationDescriptorWithSource ? ((string = KlibMetadataSerializerExtensionKt.findKDocString((DeclarationDescriptorWithSource)((DeclarationDescriptorWithSource)descriptor))) == null ? "" : string) : "";
        $this$semanticdbDocumentation_u24lambda_u2d4.setMessage("```kt\n" + signature2 + "\n```" + this.stripKDocAsterisks(kdoc));
        Semanticdb.Documentation documentation = builder.build();
        Intrinsics.checkNotNullExpressionValue(documentation, "newBuilder().apply(block).build()");
        return documentation;
    }

    private final String stripKDocAsterisks(String kdoc) {
        CharSequence charSequence = kdoc;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return kdoc;
        }
        StringBuilder out = new StringBuilder().append("\n\n").append("----").append("\n");
        Sequence<String> $this$forEach$iv = StringsKt.lineSequence(kdoc);
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int n;
            String element$iv;
            String line = element$iv = iterator2.next();
            boolean bl2 = false;
            CharSequence charSequence2 = line;
            int n2 = 0;
            if (charSequence2.length() == 0) continue;
            int start = 0;
            while (start < line.length() && CharsKt.isWhitespace(line.charAt(start))) {
                n2 = start;
                start = n2 + 1;
            }
            if (start < line.length() && line.charAt(start) == '/') {
                n2 = start;
                start = n2 + 1;
            }
            while (start < line.length() && line.charAt(start) == '*') {
                n2 = start;
                start = n2 + 1;
            }
            int end = line.length() - 1;
            if (end > start && line.charAt(end) == '/') {
                n = end;
                end = n + -1;
            }
            while (end > start && line.charAt(end) == '*') {
                n = end;
                end = n + -1;
            }
            while (end > start && CharsKt.isWhitespace(line.charAt(end))) {
                n = end;
                end = n + -1;
            }
            n = line.length() - 1;
            boolean bl3 = false;
            if (end > (start = Math.min(start, n))) {
                n = end;
                end = n + 1;
            }
            out.append("\n").append(line, start, end);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue(string, "out.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/sourcegraph/semanticdb_kotlinc/SemanticdbTextDocumentBuilder$Companion;", "", "()V", "displayName", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "semanticdb-kotlinc"})
    public static final class Companion {
        private Companion() {
        }

        private final String displayName(PsiElement element) {
            String string;
            PsiElement psiElement = element;
            if (psiElement instanceof KtPropertyAccessor) {
                String string2 = ((KtPropertyAccessor)element).getNamePlaceholder().getText();
                Intrinsics.checkNotNullExpressionValue(string2, "element.namePlaceholder.text");
                string = string2;
            } else if (psiElement instanceof NavigationItem) {
                Object object;
                Object object2;
                PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element);
                if (psiNamedElement instanceof KtConstructor) {
                    object2 = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element);
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtConstructor<*>");
                    }
                    String string3 = ((KtConstructor)object2).getName();
                    object = string3;
                    Intrinsics.checkNotNull(string3);
                } else {
                    object2 = ((NavigationItem)element).getName();
                    object = object2 == null ? element.getText() : object2;
                }
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue(object3, "when (element.namedUnwra\u2026ext\n                    }");
                string = object3;
            } else {
                String string4 = element.getText();
                Intrinsics.checkNotNullExpressionValue(string4, "element.text");
                string = string4;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

