/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_kotlinc;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.navigation.NavigationItem;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sourcegraph/semanticdb_kotlinc/LineMap;", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;)V", "document", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "endCharacter", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "lineNumber", "offsetToLineAndCol", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumn;", "offset", "startCharacter", "Companion", "semanticdb-kotlinc"})
public final class LineMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;

    public LineMap(@NotNull Project project, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(file, "file");
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file);
        Intrinsics.checkNotNull(document);
        Document document2 = document;
        Intrinsics.checkNotNullExpressionValue(document2, "getInstance(project).getDocument(file)!!");
        this.document = document2;
    }

    private final PsiDiagnosticUtils.LineAndColumn offsetToLineAndCol(int offset) {
        PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.offsetToLineAndColumn((Document)this.document, (int)offset);
        Intrinsics.checkNotNullExpressionValue(lineAndColumn, "offsetToLineAndColumn(document, offset)");
        return lineAndColumn;
    }

    public final int startCharacter(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.offsetToLineAndCol(element.getTextOffset()).getColumn();
    }

    public final int endCharacter(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.startCharacter(element) + Companion.nameForOffset(element).length();
    }

    public final int lineNumber(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.document.getLineNumber(element.getTextOffset()) + 1;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sourcegraph/semanticdb_kotlinc/LineMap$Companion;", "", "()V", "nameForOffset", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "semanticdb-kotlinc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String nameForOffset(@NotNull PsiElement element) {
            String string;
            Intrinsics.checkNotNullParameter(element, "element");
            PsiElement psiElement = element;
            if (psiElement instanceof KtPropertyAccessor) {
                String string2 = ((KtPropertyAccessor)element).getNamePlaceholder().getText();
                Intrinsics.checkNotNullExpressionValue(string2, "element.namePlaceholder.text");
                string = string2;
            } else if (psiElement instanceof NavigationItem) {
                String string3 = ((NavigationItem)element).getName();
                String string4 = string3 == null ? element.getText() : string3;
                Intrinsics.checkNotNullExpressionValue(string4, "element.name ?: element.text");
                string = string4;
            } else {
                String string5 = element.getText();
                Intrinsics.checkNotNullExpressionValue(string5, "element.text");
                string = string5;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

