/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_kotlinc;

import com.sourcegraph.semanticdb_kotlinc.DescriptorResolver;
import com.sourcegraph.semanticdb_kotlinc.GlobalSymbolsCache;
import com.sourcegraph.semanticdb_kotlinc.LineMap;
import com.sourcegraph.semanticdb_kotlinc.Semanticdb;
import com.sourcegraph.semanticdb_kotlinc.SemanticdbVisitor;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.contracts.ExperimentalContracts;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ0\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0014\u0010\u001e\u001a\u00020\b2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020\u001dH\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/sourcegraph/semanticdb_kotlinc/Analyzer;", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "sourceroot", "Ljava/nio/file/Path;", "targetroot", "callback", "Lkotlin/Function1;", "Lcom/sourcegraph/semanticdb_kotlinc/Semanticdb$TextDocument;", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "globals", "Lcom/sourcegraph/semanticdb_kotlinc/GlobalSymbolsCache;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getSourceroot", "()Ljava/nio/file/Path;", "getTargetroot", "analysisCompleted", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "handleException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "semanticdbOutPathForFile", "file", "semanticdb-kotlinc"})
@ExperimentalContracts
public final class Analyzer
implements AnalysisHandlerExtension {
    @NotNull
    private final Path sourceroot;
    @NotNull
    private final Path targetroot;
    @NotNull
    private final Function1<Semanticdb.TextDocument, Unit> callback;
    @NotNull
    private final GlobalSymbolsCache globals;
    @NotNull
    private final MessageCollector messageCollector;

    public Analyzer(@NotNull Path sourceroot, @NotNull Path targetroot, @NotNull Function1<? super Semanticdb.TextDocument, Unit> callback) {
        Intrinsics.checkNotNullParameter(sourceroot, "sourceroot");
        Intrinsics.checkNotNullParameter(targetroot, "targetroot");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.sourceroot = sourceroot;
        this.targetroot = targetroot;
        this.callback = callback;
        this.globals = new GlobalSymbolsCache(false, 1, null);
        Object object = new CompilerConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, false));
        Intrinsics.checkNotNullExpressionValue(object, "CompilerConfiguration()\n\u2026PLAIN_FULL_PATHS, false))");
        this.messageCollector = (MessageCollector)object;
    }

    @NotNull
    public final Path getSourceroot() {
        return this.sourceroot;
    }

    @NotNull
    public final Path getTargetroot() {
        return this.targetroot;
    }

    @NotNull
    public final Function1<Semanticdb.TextDocument, Unit> getCallback() {
        return this.callback;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files) {
        AnalysisResult analysisResult;
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(files, "files");
        try {
            DescriptorResolver descriptorResolver = new DescriptorResolver(bindingTrace);
            boolean bl = false;
            boolean bl2 = false;
            DescriptorResolver it = descriptorResolver;
            boolean bl3 = false;
            this.globals.setResolver(it);
            DescriptorResolver resolver = descriptorResolver;
            for (KtFile ktFile : files) {
                try {
                    LineMap lineMap = new LineMap(project, ktFile);
                    Semanticdb.TextDocument document = new SemanticdbVisitor(this.sourceroot, resolver, ktFile, lineMap, this.globals, null, 32, null).build();
                    Path path = this.semanticdbOutPathForFile(ktFile);
                    if (path != null) {
                        void $this$analysisCompleted_u24lambda_u2d2_u24lambda_u2d1;
                        Path path2 = path;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Path $this$analysisCompleted_u24lambda_u2d2 = path2;
                        boolean bl6 = false;
                        boolean $i$f$TextDocuments = false;
                        Semanticdb.TextDocuments.Builder builder = Semanticdb.TextDocuments.newBuilder();
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Semanticdb.TextDocuments.Builder builder2 = builder;
                        Path path3 = $this$analysisCompleted_u24lambda_u2d2;
                        boolean bl9 = false;
                        $this$analysisCompleted_u24lambda_u2d2_u24lambda_u2d1.addDocuments(document);
                        Unit unit = Unit.INSTANCE;
                        Semanticdb.TextDocuments textDocuments = builder.build();
                        Intrinsics.checkNotNullExpressionValue(textDocuments, "newBuilder().apply(block).build()");
                        Files.write(path3, textDocuments.toByteArray(), new OpenOption[0]);
                    }
                    this.callback.invoke(document);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            analysisResult = AnalysisHandlerExtension.DefaultImpls.analysisCompleted((AnalysisHandlerExtension)this, (Project)project, (ModuleDescriptor)module, (BindingTrace)bindingTrace, files);
        }
        catch (Exception e) {
            this.handleException(e);
            analysisResult = AnalysisHandlerExtension.DefaultImpls.analysisCompleted((AnalysisHandlerExtension)this, (Project)project, (ModuleDescriptor)module, (BindingTrace)bindingTrace, files);
        }
        return analysisResult;
    }

    private final Path semanticdbOutPathForFile(KtFile file) {
        Path normalizedPath = Paths.get(file.getVirtualFilePath(), new String[0]).normalize();
        if (normalizedPath.startsWith(this.sourceroot)) {
            Path relative = this.sourceroot.relativize(normalizedPath);
            String filename = relative.getFileName() + ".semanticdb";
            Path semanticdbOutPath = this.targetroot.resolve("META-INF").resolve("semanticdb").resolve(relative).resolveSibling(filename);
            Files.createDirectories(semanticdbOutPath.getParent(), new FileAttribute[0]);
            return semanticdbOutPath;
        }
        System.err.println("given file is not under the sourceroot.\n\tSourceroot: " + this.sourceroot + "\n\tFile path: " + file.getVirtualFilePath() + "\n\tNormalized file path: " + normalizedPath);
        return null;
    }

    private final void handleException(Exception e) {
        PrintWriter writer2 = new PrintWriter(new Writer(this){
            @NotNull
            private final StringBuffer buf;
            final /* synthetic */ Analyzer this$0;
            {
                this.this$0 = $receiver;
                this.buf = new StringBuffer();
            }

            @NotNull
            public final StringBuffer getBuf() {
                return this.buf;
            }

            public void close() {
                MessageCollector messageCollector = Analyzer.access$getMessageCollector$p(this.this$0);
                String string = this.buf.toString();
                Intrinsics.checkNotNullExpressionValue(string, "buf.toString()");
                MessageCollector.DefaultImpls.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.EXCEPTION, (String)string, null, (int)4, null);
            }

            public void flush() {
            }

            public void write(@NotNull char[] data, int offset, int len) {
                Intrinsics.checkNotNullParameter(data, "data");
                this.buf.append(data, offset, len);
            }
        }, false);
        writer2.println("Exception in semanticdb-kotlin compiler plugin:");
        e.printStackTrace(writer2);
        writer2.println("Please report a bug to https://github.com/sourcegraph/lsif-kotlin with the stack trace above.");
        writer2.close();
    }

    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        return AnalysisHandlerExtension.DefaultImpls.doAnalysis((AnalysisHandlerExtension)this, (Project)project, (ModuleDescriptor)module, (ProjectContext)projectContext, files, (BindingTrace)bindingTrace, (ComponentProvider)componentProvider);
    }

    public static final /* synthetic */ MessageCollector access$getMessageCollector$p(Analyzer $this) {
        return $this.messageCollector;
    }
}

