/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.NamedModel;
import com.smartsheet.api.models.Report;
import com.smartsheet.api.models.Sheet;
import com.smartsheet.api.models.Sight;
import com.smartsheet.api.models.Template;
import java.util.List;

public class Folder
extends NamedModel<Long> {
    private List<Sheet> sheets;
    private List<Folder> folders;
    private List<Report> reports;
    private List<Template> templates;
    private List<Sight> sights;
    private Boolean favorite;
    private String permalink;

    public Folder() {
    }

    public Folder(Long id) {
        this.setId(id);
    }

    public Folder setName(String name) {
        super.setName(name);
        return this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public Folder setPermalink(String permalink) {
        this.permalink = permalink;
        return this;
    }

    public Boolean getFavorite() {
        return this.favorite;
    }

    public Folder setFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    public List<Sheet> getSheets() {
        return this.sheets;
    }

    public Folder setSheets(List<Sheet> sheets) {
        this.sheets = sheets;
        return this;
    }

    public List<Folder> getFolders() {
        return this.folders;
    }

    public Folder setFolders(List<Folder> folders) {
        this.folders = folders;
        return this;
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public Folder setReports(List<Report> reports) {
        this.reports = reports;
        return this;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public Folder setTemplates(List<Template> templates) {
        this.templates = templates;
        return this;
    }

    public List<Sight> getSights() {
        return this.sights;
    }

    public Folder setSights(List<Sight> sights) {
        this.sights = sights;
        return this;
    }

    public static class CreateFolderBuilder {
        private String folderName;

        public CreateFolderBuilder setName(String name) {
            this.folderName = name;
            return this;
        }

        public String getName() {
            return this.folderName;
        }

        public Folder build() {
            if (this.folderName == null) {
                throw new IllegalStateException("A folder name is required.");
            }
            Folder folder = new Folder();
            folder.setName(this.folderName);
            return folder;
        }
    }

    public static class UpdateFolderBuilder {
        private String folderName;
        private Long id;

        public UpdateFolderBuilder setName(String name) {
            this.folderName = name;
            return this;
        }

        public String getName() {
            return this.folderName;
        }

        public Long getId() {
            return this.id;
        }

        public UpdateFolderBuilder setId(Long id) {
            this.id = id;
            return this;
        }

        public Folder build() {
            if (this.folderName == null) {
                throw new IllegalStateException("A folder name is required.");
            }
            Folder folder = new Folder();
            folder.setId(this.id);
            folder.setName(this.folderName);
            return folder;
        }
    }
}

