/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.ObjectValue;
import com.smartsheet.api.models.enums.ObjectValueType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateObjectValue
implements ObjectValue {
    public static final String ABSTRACT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private ObjectValueType objectType;
    private String value;
    private Date date;

    public static DateObjectValue fromDate(ObjectValueType objectValueType, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateObjectValue.getFormatPattern(objectValueType));
        String value = simpleDateFormat.format(date);
        return new DateObjectValue(objectValueType, value);
    }

    public DateObjectValue(ObjectValueType objectType, String value) {
        this.objectType = objectType;
        this.value = value;
    }

    @Override
    public ObjectValueType getObjectType() {
        return this.objectType;
    }

    public DateObjectValue setObjectType(ObjectValueType objectType) {
        this.objectType = objectType;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public DateObjectValue setValue(String value) {
        this.value = value;
        return this;
    }

    public Date toDate() throws ParseException {
        if (this.date == null && this.value != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateObjectValue.getFormatPattern(this.objectType));
            this.date = simpleDateFormat.parse(this.value);
        }
        return this.date;
    }

    private static String getFormatPattern(ObjectValueType objectValueType) {
        if (objectValueType != null) {
            switch (objectValueType) {
                case ABSTRACT_DATETIME: {
                    return ABSTRACT_DATETIME_FORMAT;
                }
                case DATETIME: {
                    return DATETIME_FORMAT;
                }
                case DATE: {
                    return DATE_FORMAT;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported objectValueType: " + (Object)((Object)objectValueType));
    }
}

