/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.AutoNumberFormat;
import com.smartsheet.api.models.Contact;
import com.smartsheet.api.models.IdentifiableModel;
import com.smartsheet.api.models.enums.ColumnTag;
import com.smartsheet.api.models.enums.ColumnType;
import com.smartsheet.api.models.enums.Symbol;
import com.smartsheet.api.models.enums.SystemColumnType;
import com.smartsheet.api.models.format.Format;
import java.util.List;

public class Column
extends IdentifiableModel<Long> {
    private SystemColumnType systemColumnType;
    private ColumnType type;
    private AutoNumberFormat autoNumberFormat;
    private List<Contact> contactOptions;
    private String description;
    private Format format;
    private Boolean hidden;
    private Integer index;
    private Boolean locked;
    private Boolean lockedForUser;
    private List<String> options;
    private Boolean primary;
    private Symbol symbol;
    private List<ColumnTag> tags;
    private String title;
    private Boolean validation;
    private Integer version;
    private Integer width;

    public Column() {
    }

    public Column(Long id) {
        this.setId(id);
    }

    public SystemColumnType getSystemColumnType() {
        return this.systemColumnType;
    }

    public Column setSystemColumnType(SystemColumnType systemColumnType) {
        this.systemColumnType = systemColumnType;
        return this;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Column setType(ColumnType type) {
        this.type = type;
        return this;
    }

    public AutoNumberFormat getAutoNumberFormat() {
        return this.autoNumberFormat;
    }

    public Column setAutoNumberFormat(AutoNumberFormat autoNumberFormat) {
        this.autoNumberFormat = autoNumberFormat;
        return this;
    }

    public List<Contact> getContactOptions() {
        return this.contactOptions;
    }

    public Column setContactOptions(List<Contact> contactOptions) {
        this.contactOptions = contactOptions;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Column setDescription(String description) {
        this.description = description;
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    public Column setFormat(Format format) {
        this.format = format;
        return this;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Column setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Column setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public Column setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    public Boolean isLockedForUser() {
        return this.lockedForUser;
    }

    public Column setLockedForUser(Boolean lockedForUser) {
        this.lockedForUser = lockedForUser;
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public Column setOptions(List<String> options) {
        this.options = options;
        return this;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public Column setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Column setSymbol(Symbol symbol) {
        this.symbol = symbol;
        return this;
    }

    public List<ColumnTag> getTags() {
        return this.tags;
    }

    public Column setTags(List<ColumnTag> tags) {
        this.tags = tags;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Column setTitle(String title) {
        this.title = title;
        return this;
    }

    public Boolean getValidation() {
        return this.validation;
    }

    public Column setValidation(Boolean validation) {
        this.validation = validation;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Column setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Column setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public static class UpdateColumnBuilder {
        private int index;
        private String title;
        private ColumnType type;
        private List<String> options;
        private Symbol symbol;
        private SystemColumnType systemColumnType;
        private AutoNumberFormat autoNumberFormat;
        private Long sheetId;
        private Integer width;
        private Format format;
        private Long id;
        private Boolean validation;

        public Long getColumnId() {
            return this.id;
        }

        public UpdateColumnBuilder setColumnId(Long columnId) {
            this.id = columnId;
            return this;
        }

        public UpdateColumnBuilder setIndex(int index) {
            this.index = index;
            return this;
        }

        public UpdateColumnBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public UpdateColumnBuilder setType(ColumnType type) {
            this.type = type;
            return this;
        }

        public UpdateColumnBuilder setOptions(List<String> options) {
            this.options = options;
            return this;
        }

        public UpdateColumnBuilder setSymbol(Symbol symbol) {
            this.symbol = symbol;
            return this;
        }

        public UpdateColumnBuilder setSystemColumnType(SystemColumnType systemColumnType) {
            this.systemColumnType = systemColumnType;
            return this;
        }

        public UpdateColumnBuilder setAutoNumberFormat(AutoNumberFormat autoNumberFormat) {
            this.autoNumberFormat = autoNumberFormat;
            return this;
        }

        public UpdateColumnBuilder setSheetId(Long sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public UpdateColumnBuilder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public UpdateColumnBuilder setWidth(Integer width) {
            this.width = width;
            return this;
        }

        public UpdateColumnBuilder setValidation(Boolean validation) {
            this.validation = validation;
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return this.title;
        }

        public ColumnType getType() {
            return this.type;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public SystemColumnType getSystemColumnType() {
            return this.systemColumnType;
        }

        public AutoNumberFormat getAutoNumberFormat() {
            return this.autoNumberFormat;
        }

        public Long getSheetId() {
            return this.sheetId;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Format getFormat() {
            return this.format;
        }

        public Boolean getValidation() {
            return this.validation;
        }

        public Column build() {
            if (this.title == null || this.id == null) {
                throw new InstantiationError("A title and a column id are required");
            }
            Column column = new Column();
            column.index = this.index;
            column.title = this.title;
            column.type = this.type;
            column.options = this.options;
            column.symbol = this.symbol;
            column.systemColumnType = this.systemColumnType;
            column.autoNumberFormat = this.autoNumberFormat;
            column.width = this.width;
            column.format = this.format;
            column.validation = this.validation;
            column.setId(this.id);
            return column;
        }
    }

    public static class AddColumnToSheetBuilder {
        private String title;
        private Integer index;
        private ColumnType type;
        private List<String> options;
        private Symbol symbol;
        private SystemColumnType systemColumnType;
        private AutoNumberFormat autoNumberFormat;
        private Integer width;
        private Boolean primary;
        private Format format;
        private Boolean validation;

        public Integer getWidth() {
            return this.width;
        }

        public AddColumnToSheetBuilder setWidth(Integer width) {
            this.width = width;
            return this;
        }

        public Boolean getPrimary() {
            return this.primary;
        }

        public AddColumnToSheetBuilder setPrimary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public AddColumnToSheetBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public AddColumnToSheetBuilder setType(ColumnType type) {
            this.type = type;
            return this;
        }

        public ColumnType getType() {
            return this.type;
        }

        public AddColumnToSheetBuilder setOptions(List<String> options) {
            this.options = options;
            return this;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public AddColumnToSheetBuilder setSymbol(Symbol symbol) {
            this.symbol = symbol;
            return this;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public AddColumnToSheetBuilder setSystemColumnType(SystemColumnType systemColumnType) {
            this.systemColumnType = systemColumnType;
            return this;
        }

        public SystemColumnType getSystemColumnType() {
            return this.systemColumnType;
        }

        public AddColumnToSheetBuilder setAutoNumberFormat(AutoNumberFormat autoNumberFormat) {
            this.autoNumberFormat = autoNumberFormat;
            return this;
        }

        public AutoNumberFormat getAutoNumberFormat() {
            return this.autoNumberFormat;
        }

        public Integer getIndex() {
            return this.index;
        }

        public AddColumnToSheetBuilder setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public Format getFormat() {
            return this.format;
        }

        public AddColumnToSheetBuilder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public Boolean getValidation() {
            return this.validation;
        }

        public AddColumnToSheetBuilder setValidation(Boolean validation) {
            this.validation = validation;
            return this;
        }

        public Column build() {
            if (this.title == null || this.type == null) {
                throw new InstantiationError();
            }
            Column column = new Column();
            column.title = this.title;
            column.type = this.type;
            column.options = this.options;
            column.symbol = this.symbol;
            column.index = this.index;
            column.width = this.width;
            column.systemColumnType = this.systemColumnType;
            column.autoNumberFormat = this.autoNumberFormat;
            column.primary = this.primary;
            column.format = this.format;
            column.validation = this.validation;
            return column;
        }
    }
}

