/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.AbstractRow;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.ContactObjectValue;
import com.smartsheet.api.models.CrossSheetReference;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.NamedModel;
import com.smartsheet.api.models.ProjectSettings;
import com.smartsheet.api.models.SheetFilter;
import com.smartsheet.api.models.SheetSummary;
import com.smartsheet.api.models.SheetUserPermissions;
import com.smartsheet.api.models.SheetUserSettings;
import com.smartsheet.api.models.Source;
import com.smartsheet.api.models.Workspace;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.enums.AttachmentType;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class AbstractSheet<TRow extends AbstractRow<TColumn, TCell>, TColumn extends Column, TCell extends Cell>
extends NamedModel<Long> {
    private Long fromId;
    private Long ownerId;
    private AccessLevel accessLevel;
    private List<Attachment> attachments;
    private List<TColumn> columns;
    private List<ContactObjectValue> contactReferences;
    private Date createdAt;
    private List<CrossSheetReference> crossSheetReferences;
    private Boolean dependenciesEnabled;
    private List<Discussion> discussions;
    private EnumSet<AttachmentType> effectiveAttachmentOptions;
    private Boolean favorite;
    private List<SheetFilter> filters;
    private Boolean ganttEnabled;
    private Boolean hasSummaryFields;
    private Date modifiedAt;
    private String owner;
    private String permalink;
    private ProjectSettings projectSettings;
    private Boolean readOnly;
    private Boolean resourceManagementEnabled;
    private List<TRow> rows;
    private Boolean showParentRowsForFilters;
    private Source source;
    private SheetSummary summary;
    private Integer totalRowCount;
    private SheetUserPermissions userPermissions;
    private SheetUserSettings userSettings;
    private Integer version;
    private Workspace workspace;

    public Long getFromId() {
        return this.fromId;
    }

    public AbstractSheet<TRow, TColumn, TCell> setFromId(Long fromId) {
        this.fromId = fromId;
        return this;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public AbstractSheet<TRow, TColumn, TCell> setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public AbstractSheet<TRow, TColumn, TCell> setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public AbstractSheet<TRow, TColumn, TCell> setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public AbstractSheet<TRow, TColumn, TCell> setColumns(List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<ContactObjectValue> getContactReferences() {
        return this.contactReferences;
    }

    public AbstractSheet<TRow, TColumn, TCell> setContactReferences(List<ContactObjectValue> contactReferences) {
        this.contactReferences = contactReferences;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public AbstractSheet<TRow, TColumn, TCell> setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public List<CrossSheetReference> getCrossSheetReferences() {
        return this.crossSheetReferences;
    }

    public AbstractSheet<TRow, TColumn, TCell> setCrossSheetReferences(List<CrossSheetReference> crossSheetReferences) {
        this.crossSheetReferences = crossSheetReferences;
        return this;
    }

    public Boolean getDependenciesEnabled() {
        return this.dependenciesEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setDependenciesEnabled(Boolean dependenciesEnabled) {
        this.dependenciesEnabled = dependenciesEnabled;
        return this;
    }

    public List<Discussion> getDiscussions() {
        return this.discussions;
    }

    public AbstractSheet<TRow, TColumn, TCell> setDiscussions(List<Discussion> discussions) {
        this.discussions = discussions;
        return this;
    }

    public EnumSet<AttachmentType> getEffectiveAttachmentOptions() {
        return this.effectiveAttachmentOptions;
    }

    public AbstractSheet<TRow, TColumn, TCell> setEffectiveAttachmentOptions(EnumSet<AttachmentType> effectiveAttachmentOptions) {
        this.effectiveAttachmentOptions = effectiveAttachmentOptions;
        return this;
    }

    public Boolean isFavorite() {
        return this.favorite;
    }

    public AbstractSheet<TRow, TColumn, TCell> setFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    public List<SheetFilter> getFilters() {
        return this.filters;
    }

    public AbstractSheet<TRow, TColumn, TCell> setFilters(List<SheetFilter> filters) {
        this.filters = filters;
        return this;
    }

    public Boolean getGanttEnabled() {
        return this.ganttEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setGanttEnabled(Boolean ganttEnabled) {
        this.ganttEnabled = ganttEnabled;
        return this;
    }

    public Boolean getHasSummaryFields() {
        return this.hasSummaryFields;
    }

    public AbstractSheet<TRow, TColumn, TCell> setHasSummaryFields(Boolean hasSummaryFields) {
        this.hasSummaryFields = hasSummaryFields;
        return this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public AbstractSheet<TRow, TColumn, TCell> setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public AbstractSheet<TRow, TColumn, TCell> setName(String name) {
        super.setName(name);
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public AbstractSheet<TRow, TColumn, TCell> setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public AbstractSheet<TRow, TColumn, TCell> setPermalink(String permalink) {
        this.permalink = permalink;
        return this;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public AbstractSheet<TRow, TColumn, TCell> setProjectSettings(ProjectSettings projectSettings) {
        this.projectSettings = projectSettings;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public AbstractSheet<TRow, TColumn, TCell> setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getResourceManagementEnabled() {
        return this.resourceManagementEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setResourceManagementEnabled(Boolean resourceManagementEnabled) {
        this.resourceManagementEnabled = resourceManagementEnabled;
        return this;
    }

    public List<TRow> getRows() {
        return this.rows;
    }

    public AbstractSheet<TRow, TColumn, TCell> setRows(List<TRow> rows) {
        this.rows = rows;
        return this;
    }

    public Boolean getShowParentRowsForFilters() {
        return this.showParentRowsForFilters;
    }

    public AbstractSheet<TRow, TColumn, TCell> setShowParentRowsForFilters(Boolean showParentRowsForFilters) {
        this.showParentRowsForFilters = showParentRowsForFilters;
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public AbstractSheet<TRow, TColumn, TCell> setSource(Source source) {
        this.source = source;
        return this;
    }

    public SheetSummary getSummary() {
        return this.summary;
    }

    public AbstractSheet<TRow, TColumn, TCell> setSummary(SheetSummary summary) {
        this.summary = summary;
        return this;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public AbstractSheet<TRow, TColumn, TCell> setTotalRowCount(Integer totalRowCount) {
        this.totalRowCount = totalRowCount;
        return this;
    }

    public SheetUserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    public AbstractSheet<TRow, TColumn, TCell> setUserPermissions(SheetUserPermissions userPermissions) {
        this.userPermissions = userPermissions;
        return this;
    }

    public SheetUserSettings getUserSettings() {
        return this.userSettings;
    }

    public AbstractSheet<TRow, TColumn, TCell> setUserSettings(SheetUserSettings userSettings) {
        this.userSettings = userSettings;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public AbstractSheet<TRow, TColumn, TCell> setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public AbstractSheet<TRow, TColumn, TCell> setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public TColumn getColumnByIndex(int index) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if (column.getIndex() != index) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TColumn getColumnById(long columnId) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if ((Long)column.getId() != columnId) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TRow getRowByRowNumber(int rowNumber) {
        if (this.rows == null) {
            return null;
        }
        AbstractRow result = null;
        for (AbstractRow row : this.rows) {
            if (row.getRowNumber() != rowNumber) continue;
            result = row;
            break;
        }
        return (TRow)result;
    }
}

