/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.IdentifiableModel;
import com.smartsheet.api.models.User;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.format.Format;
import java.util.Date;
import java.util.List;

public class AbstractRow<TColumn extends Column, TCell extends Cell>
extends IdentifiableModel<Long> {
    private Long sheetId;
    private Integer rowNumber;
    private Integer parentRowNumber;
    private List<TCell> cells;
    private List<Discussion> discussions;
    private List<Attachment> attachments;
    private List<TColumn> columns;
    private Date createdAt;
    private Date modifiedAt;
    private Boolean expanded;
    private Integer version;
    private AccessLevel accessLevel;
    private Boolean locked;
    private Boolean lockedForUser;
    private Format format;
    private Long parentId;
    private Long siblingId;
    private String permalink;
    private Boolean filteredOut;
    private Boolean inCriticalPath;
    private Format conditionalFormat;
    private Boolean toTop;
    private Boolean toBottom;
    private Boolean above;
    private Integer indent;
    private Integer outdent;
    private User createdBy;
    private User modifiedBy;

    @Override
    @JsonIgnore(value=false)
    public Long getId() {
        return (Long)super.getId();
    }

    @Override
    @JsonIgnore(value=false)
    public IdentifiableModel<Long> setId(Long id) {
        super.setId(id);
        return this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public AbstractRow<TColumn, TCell> setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public AbstractRow<TColumn, TCell> setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Boolean isExpanded() {
        return this.expanded;
    }

    public AbstractRow<TColumn, TCell> setExpanded(Boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public TColumn getColumnByIndex(int index) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if (column.getIndex() != index) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TColumn getColumnById(long columnId) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if ((Long)column.getId() != columnId) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public Long getSheetId() {
        return this.sheetId;
    }

    public AbstractRow<TColumn, TCell> setSheetId(Long sheetId) {
        this.sheetId = sheetId;
        return this;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public AbstractRow<TColumn, TCell> setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
        return this;
    }

    public Integer getParentRowNumber() {
        return this.parentRowNumber;
    }

    public AbstractRow<TColumn, TCell> setParentRowNumber(Integer parentRowNumber) {
        this.parentRowNumber = parentRowNumber;
        return this;
    }

    public List<TCell> getCells() {
        return this.cells;
    }

    public AbstractRow<TColumn, TCell> setCells(List<TCell> cells) {
        this.cells = cells;
        return this;
    }

    public List<Discussion> getDiscussions() {
        return this.discussions;
    }

    public AbstractRow<TColumn, TCell> setDiscussions(List<Discussion> discussions) {
        this.discussions = discussions;
        return this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public AbstractRow<TColumn, TCell> setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public AbstractRow<TColumn, TCell> setColumns(List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public AbstractRow<TColumn, TCell> setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public AbstractRow<TColumn, TCell> setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public AbstractRow<TColumn, TCell> setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    public Boolean isLockedForUser() {
        return this.lockedForUser;
    }

    public AbstractRow<TColumn, TCell> setLockedForUser(Boolean lockedForUser) {
        this.lockedForUser = lockedForUser;
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    public AbstractRow<TColumn, TCell> setFormat(Format format) {
        this.format = format;
        return this;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public AbstractRow<TColumn, TCell> setParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public Long getSiblingId() {
        return this.siblingId;
    }

    public AbstractRow<TColumn, TCell> setSiblingId(Long siblingId) {
        this.siblingId = siblingId;
        return this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public AbstractRow<TColumn, TCell> setPermalink(String permalink) {
        this.permalink = permalink;
        return this;
    }

    public Boolean isFilteredOut() {
        return this.filteredOut;
    }

    public AbstractRow<TColumn, TCell> setFilteredOut(Boolean filteredOut) {
        this.filteredOut = filteredOut;
        return this;
    }

    public Boolean isInCriticalPath() {
        return this.inCriticalPath;
    }

    public AbstractRow<TColumn, TCell> setInCriticalPath(Boolean inCriticalPath) {
        this.inCriticalPath = inCriticalPath;
        return this;
    }

    public Format getConditionalFormat() {
        return this.conditionalFormat;
    }

    public AbstractRow<TColumn, TCell> setConditionalFormat(Format conditionalFormat) {
        this.conditionalFormat = conditionalFormat;
        return this;
    }

    public Boolean getToTop() {
        return this.toTop;
    }

    public AbstractRow<TColumn, TCell> setToTop(Boolean toTop) {
        this.toTop = toTop;
        return this;
    }

    public Boolean getToBottom() {
        return this.toBottom;
    }

    public AbstractRow<TColumn, TCell> setToBottom(Boolean toBottom) {
        this.toBottom = toBottom;
        return this;
    }

    public Boolean getAbove() {
        return this.above;
    }

    public AbstractRow<TColumn, TCell> setAbove(Boolean above) {
        this.above = above;
        return this;
    }

    public Integer getIndent() {
        return this.indent;
    }

    public AbstractRow<TColumn, TCell> setIndent(Integer indent) {
        this.indent = indent;
        return this;
    }

    public Integer getOutdent() {
        return this.outdent;
    }

    public AbstractRow<TColumn, TCell> setOutdent(Integer outdent) {
        this.outdent = outdent;
        return this;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }
}

