/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartsheet.api.models.BooleanObjectValue;
import com.smartsheet.api.models.ContactObjectValue;
import com.smartsheet.api.models.DateObjectValue;
import com.smartsheet.api.models.Duration;
import com.smartsheet.api.models.MultiContactObjectValue;
import com.smartsheet.api.models.MultiPicklistObjectValue;
import com.smartsheet.api.models.NumberObjectValue;
import com.smartsheet.api.models.ObjectValue;
import com.smartsheet.api.models.Predecessor;
import com.smartsheet.api.models.PredecessorList;
import com.smartsheet.api.models.StringObjectValue;
import com.smartsheet.api.models.enums.ObjectValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectValueDeserializer
extends JsonDeserializer<ObjectValue> {
    public ObjectValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectValue objectValue;
        ContactObjectValue contactObjectValue = null;
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            ObjectValueType parsedObjectType;
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ObjectValueAttributeSuperset superset = (ObjectValueAttributeSuperset)mapper.readValue(jp, ObjectValueAttributeSuperset.class);
            try {
                parsedObjectType = ObjectValueType.valueOf(superset.objectType);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            switch (parsedObjectType) {
                case DURATION: {
                    objectValue = new Duration(superset.negative, superset.elapsed, superset.weeks, superset.days, superset.hours, superset.minutes, superset.seconds, superset.milliseconds);
                    break;
                }
                case PREDECESSOR_LIST: {
                    objectValue = new PredecessorList(superset.predecessors);
                    break;
                }
                case CONTACT: {
                    contactObjectValue = new ContactObjectValue();
                    contactObjectValue.setName(superset.name);
                    contactObjectValue.setEmail(superset.email);
                    contactObjectValue.setId(superset.id);
                    objectValue = contactObjectValue;
                    break;
                }
                case DATE: 
                case DATETIME: 
                case ABSTRACT_DATETIME: {
                    objectValue = new DateObjectValue(parsedObjectType, superset.value);
                    break;
                }
                case MULTI_CONTACT: {
                    ArrayList<ContactObjectValue> contactObjectValues = new ArrayList<ContactObjectValue>();
                    for (Object contact : superset.values) {
                        contactObjectValue = (ContactObjectValue)mapper.convertValue(contact, ContactObjectValue.class);
                        contactObjectValues.add(contactObjectValue);
                    }
                    objectValue = new MultiContactObjectValue(contactObjectValues);
                    break;
                }
                case MULTI_PICKLIST: {
                    objectValue = new MultiPicklistObjectValue(superset.values);
                    break;
                }
                default: {
                    objectValue = null;
                    break;
                }
            }
        } else {
            JsonToken token = jp.getCurrentToken();
            objectValue = token.isBoolean() ? new BooleanObjectValue(jp.getBooleanValue()) : (token.isNumeric() ? new NumberObjectValue(jp.getNumberValue()) : new StringObjectValue(jp.getText()));
        }
        return objectValue;
    }

    private static class ObjectValueAttributeSuperset {
        public String objectType;
        public List<Predecessor> predecessors;
        public Boolean negative;
        public Boolean elapsed;
        public Double weeks;
        public Double days;
        public Double hours;
        public Double minutes;
        public Double seconds;
        public Double milliseconds;
        public String id;
        public String name;
        public String email;
        public List<?> values;
        public String value;

        private ObjectValueAttributeSuperset() {
        }
    }
}

