/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetFilterResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.SheetFilter;
import java.util.HashMap;

public class SheetFilterResourcesImpl
extends AbstractResources
implements SheetFilterResources {
    public SheetFilterResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public SheetFilter getFilter(long sheetId, long filterId) throws SmartsheetException {
        return this.getResource("sheets/" + sheetId + "/filters/" + filterId, SheetFilter.class);
    }

    @Override
    public void deleteFilter(long sheetId, long filterId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/filters/" + filterId, SheetFilter.class);
    }

    @Override
    public PagedResult<SheetFilter> listFilters(long sheetId, PaginationParameters pagination) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/filters";
        HashMap<String, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, SheetFilter.class);
    }
}

