/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractAssociatedResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Share;
import java.util.HashMap;
import java.util.List;

public class ShareResourcesImpl
extends AbstractAssociatedResources
implements ShareResources {
    public ShareResourcesImpl(SmartsheetImpl smartsheet, String masterResourceType) {
        super(smartsheet, masterResourceType);
    }

    @Override
    public PagedResult<Share> listShares(long objectId, PaginationParameters pagination) throws SmartsheetException {
        return this.listShares(objectId, pagination, false);
    }

    @Override
    public PagedResult<Share> listShares(long objectId, PaginationParameters pagination, Boolean includeWorkspaceShares) throws SmartsheetException {
        String path = this.getMasterResourceType() + "/" + objectId + "/shares";
        HashMap<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (includeWorkspaceShares != null && includeWorkspaceShares.booleanValue()) {
            parameters.put("include", "workspaceShares");
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Share.class);
    }

    @Override
    public Share getShare(long objectId, String shareId) throws SmartsheetException {
        return this.getResource(this.getMasterResourceType() + "/" + objectId + "/shares/" + shareId, Share.class);
    }

    @Override
    public List<Share> shareTo(long objectId, List<Share> shares, Boolean sendEmail) throws SmartsheetException {
        String path = this.getMasterResourceType() + "/" + objectId + "/shares";
        if (sendEmail != null) {
            path = path + "?sendEmail=" + sendEmail;
        }
        return this.postAndReceiveList(path, shares, Share.class);
    }

    @Override
    public Share updateShare(long objectId, Share share) throws SmartsheetException {
        Util.throwIfNull(share);
        return this.updateResource(this.getMasterResourceType() + "/" + objectId + "/shares/" + (String)share.getId(), Share.class, share);
    }

    @Override
    public void deleteShare(long objectId, String shareId) throws SmartsheetException {
        this.deleteResource(this.getMasterResourceType() + "/" + objectId + "/shares/" + shareId, Share.class);
    }
}

