/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SearchResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.SearchResult;
import com.smartsheet.api.models.enums.SearchInclusion;
import com.smartsheet.api.models.enums.SearchLocation;
import com.smartsheet.api.models.enums.SearchScope;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;

public class SearchResourcesImpl
extends AbstractResources
implements SearchResources {
    public SearchResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public SearchResult search(String query) throws SmartsheetException {
        return this.search(query, null, null, null, null);
    }

    @Override
    public SearchResult search(String query, EnumSet<SearchInclusion> includes, SearchLocation location, Date modifiedSince, EnumSet<SearchScope> scopes) throws SmartsheetException {
        Util.throwIfNull(query);
        Util.throwIfEmpty(query);
        String path = "search";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("location", (Object)location);
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        parameters.put("scopes", QueryUtil.generateCommaSeparatedList(scopes));
        try {
            parameters.put("query", URLEncoder.encode(query, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, SearchResult.class);
    }

    @Override
    public SearchResult searchSheet(long sheetId, String query) throws SmartsheetException {
        Util.throwIfNull(query);
        Util.throwIfEmpty(query);
        try {
            return this.getResource("search/sheets/" + sheetId + "?query=" + URLEncoder.encode(query, "utf-8"), SearchResult.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

