/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.ContextBlockElement;
import com.slack.api.model.block.UnknownContextBlockElement;
import com.slack.api.model.block.composition.MarkdownTextObject;
import com.slack.api.model.block.composition.PlainTextObject;
import com.slack.api.model.block.element.ImageElement;
import java.lang.reflect.Type;

public class GsonContextBlockElementFactory
implements JsonDeserializer<ContextBlockElement>,
JsonSerializer<ContextBlockElement> {
    private boolean failOnUnknownProperties;

    public GsonContextBlockElementFactory() {
        this(false);
    }

    public GsonContextBlockElementFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public ContextBlockElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends ContextBlockElement> clazz = this.getContextBlockElementClassInstance(typeName);
        return (ContextBlockElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(ContextBlockElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    private Class<? extends ContextBlockElement> getContextBlockElementClassInstance(String typeName) {
        switch (typeName) {
            case "image": {
                return ImageElement.class;
            }
            case "plain_text": {
                return PlainTextObject.class;
            }
            case "mrkdwn": {
                return MarkdownTextObject.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unknown context block element type: " + typeName);
        }
        return UnknownContextBlockElement.class;
    }
}

