/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim2.impl;

import com.google.gson.annotations.SerializedName;
import com.slack.api.RequestConfigurator;
import com.slack.api.SlackConfig;
import com.slack.api.methods.impl.TeamIdCache;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.scim2.SCIM2ApiException;
import com.slack.api.scim2.SCIM2ApiRequest;
import com.slack.api.scim2.SCIM2Client;
import com.slack.api.scim2.SCIM2Config;
import com.slack.api.scim2.SCIM2EndpointName;
import com.slack.api.scim2.request.GroupsCreateRequest;
import com.slack.api.scim2.request.GroupsDeleteRequest;
import com.slack.api.scim2.request.GroupsPatchOperation;
import com.slack.api.scim2.request.GroupsPatchRequest;
import com.slack.api.scim2.request.GroupsReadRequest;
import com.slack.api.scim2.request.GroupsSearchRequest;
import com.slack.api.scim2.request.GroupsUpdateRequest;
import com.slack.api.scim2.request.ResourceTypesGetRequest;
import com.slack.api.scim2.request.ServiceProviderConfigsGetRequest;
import com.slack.api.scim2.request.UsersCreateRequest;
import com.slack.api.scim2.request.UsersDeleteRequest;
import com.slack.api.scim2.request.UsersPatchOperation;
import com.slack.api.scim2.request.UsersPatchRequest;
import com.slack.api.scim2.request.UsersReadRequest;
import com.slack.api.scim2.request.UsersSearchRequest;
import com.slack.api.scim2.request.UsersUpdateRequest;
import com.slack.api.scim2.response.GroupsCreateResponse;
import com.slack.api.scim2.response.GroupsDeleteResponse;
import com.slack.api.scim2.response.GroupsPatchResponse;
import com.slack.api.scim2.response.GroupsReadResponse;
import com.slack.api.scim2.response.GroupsSearchResponse;
import com.slack.api.scim2.response.GroupsUpdateResponse;
import com.slack.api.scim2.response.ResourceTypesGetResponse;
import com.slack.api.scim2.response.ServiceProviderConfigsGetResponse;
import com.slack.api.scim2.response.UsersCreateResponse;
import com.slack.api.scim2.response.UsersDeleteResponse;
import com.slack.api.scim2.response.UsersPatchResponse;
import com.slack.api.scim2.response.UsersReadResponse;
import com.slack.api.scim2.response.UsersSearchResponse;
import com.slack.api.scim2.response.UsersUpdateResponse;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;

public class SCIM2ClientImpl
implements SCIM2Client {
    private String endpointUrlPrefix = "https://api.slack.com/scim/v2/";
    private final SlackHttpClient slackHttpClient;
    private final String token;
    private final SCIM2Config config;
    private final String executorName;
    private final TeamIdCache teamIdCache;

    public SCIM2ClientImpl(SlackConfig config, SlackHttpClient slackHttpClient, TeamIdCache teamIdCache) {
        this(config, slackHttpClient, teamIdCache, null);
    }

    public SCIM2ClientImpl(SlackConfig config, SlackHttpClient slackHttpClient, TeamIdCache teamIdCache, String token) {
        this.slackHttpClient = slackHttpClient;
        this.token = token;
        this.config = config.getSCIM2Config();
        this.executorName = this.config.getExecutorName();
        this.teamIdCache = teamIdCache;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.endpointUrlPrefix;
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.endpointUrlPrefix = endpointUrlPrefix;
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(ServiceProviderConfigsGetRequest req) throws IOException, SCIM2ApiException {
        return this.doGet(SCIM2EndpointName.getServiceProviderConfigs, this.endpointUrlPrefix + "ServiceProviderConfigs", null, this.getToken(req), ServiceProviderConfigsGetResponse.class);
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(RequestConfigurator<ServiceProviderConfigsGetRequest.ServiceProviderConfigsGetRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.getServiceProviderConfigs(req.configure(ServiceProviderConfigsGetRequest.builder()).build());
    }

    @Override
    public ResourceTypesGetResponse getResourceTypes(ResourceTypesGetRequest req) throws IOException, SCIM2ApiException {
        return this.doGet(SCIM2EndpointName.getResourceTypes, this.endpointUrlPrefix + "ResourceTypes", null, this.getToken(req), ResourceTypesGetResponse.class);
    }

    @Override
    public ResourceTypesGetResponse getResourceTypes(RequestConfigurator<ResourceTypesGetRequest.ResourceTypesGetRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.getResourceTypes(req.configure(ResourceTypesGetRequest.builder()).build());
    }

    @Override
    public UsersSearchResponse searchUsers(UsersSearchRequest req) throws IOException, SCIM2ApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(SCIM2EndpointName.searchUsers, this.getUsersResourceURL(), query, this.getToken(req), UsersSearchResponse.class);
    }

    @Override
    public UsersSearchResponse searchUsers(RequestConfigurator<UsersSearchRequest.UsersSearchRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.searchUsers(req.configure(UsersSearchRequest.builder()).build());
    }

    @Override
    public UsersReadResponse readUser(UsersReadRequest req) throws IOException, SCIM2ApiException {
        return this.doGet(SCIM2EndpointName.readUser, this.getUsersResourceURL() + "/" + req.getId(), null, this.getToken(req), UsersReadResponse.class);
    }

    @Override
    public UsersReadResponse readUser(RequestConfigurator<UsersReadRequest.UsersReadRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.readUser(req.configure(UsersReadRequest.builder()).build());
    }

    @Override
    public UsersCreateResponse createUser(UsersCreateRequest req) throws IOException, SCIM2ApiException {
        return this.doPost(SCIM2EndpointName.createUser, this.getUsersResourceURL(), req.getUser(), this.getToken(req), UsersCreateResponse.class);
    }

    @Override
    public UsersCreateResponse createUser(RequestConfigurator<UsersCreateRequest.UsersCreateRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.createUser(req.configure(UsersCreateRequest.builder()).build());
    }

    @Override
    public UsersPatchResponse patchUser(UsersPatchRequest req) throws IOException, SCIM2ApiException {
        UsersPatchRequestBody body = UsersPatchRequestBody.builder().schemas(req.getSchemas()).operations(req.getOperations().stream().map(op -> op.toSerializable()).collect(Collectors.toList())).build();
        return this.doPatch(SCIM2EndpointName.patchUser, this.getUsersResourceURL() + "/" + req.getId(), body, this.getToken(req), UsersPatchResponse.class);
    }

    @Override
    public UsersPatchResponse patchUser(RequestConfigurator<UsersPatchRequest.UsersPatchRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.patchUser(req.configure(UsersPatchRequest.builder()).build());
    }

    @Override
    public UsersUpdateResponse updateUser(UsersUpdateRequest req) throws IOException, SCIM2ApiException {
        return this.doPut(SCIM2EndpointName.updateUser, this.getUsersResourceURL() + "/" + req.getId(), req.getUser(), this.getToken(req), UsersUpdateResponse.class);
    }

    @Override
    public UsersUpdateResponse updateUser(RequestConfigurator<UsersUpdateRequest.UsersUpdateRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.updateUser(req.configure(UsersUpdateRequest.builder()).build());
    }

    @Override
    public UsersDeleteResponse deleteUser(UsersDeleteRequest req) throws IOException, SCIM2ApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getUsersResourceURL() + "/" + req.getId());
        return this.doDelete(SCIM2EndpointName.deleteUser, requestBuilder, UsersDeleteResponse.class);
    }

    @Override
    public UsersDeleteResponse deleteUser(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.deleteUser(req.configure(UsersDeleteRequest.builder()).build());
    }

    @Override
    public GroupsSearchResponse searchGroups(GroupsSearchRequest req) throws IOException, SCIM2ApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(SCIM2EndpointName.searchGroups, this.getGroupsResourceURL(), query, this.getToken(req), GroupsSearchResponse.class);
    }

    @Override
    public GroupsSearchResponse searchGroups(RequestConfigurator<GroupsSearchRequest.GroupsSearchRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.searchGroups(req.configure(GroupsSearchRequest.builder()).build());
    }

    @Override
    public GroupsReadResponse readGroup(GroupsReadRequest req) throws IOException, SCIM2ApiException {
        return this.doGet(SCIM2EndpointName.readGroup, this.getGroupsResourceURL() + "/" + req.getId(), null, this.getToken(req), GroupsReadResponse.class);
    }

    @Override
    public GroupsReadResponse readGroup(RequestConfigurator<GroupsReadRequest.GroupsReadRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.readGroup(req.configure(GroupsReadRequest.builder()).build());
    }

    @Override
    public GroupsCreateResponse createGroup(GroupsCreateRequest req) throws IOException, SCIM2ApiException {
        return this.doPost(SCIM2EndpointName.createGroup, this.getGroupsResourceURL(), req.getGroup(), this.getToken(req), GroupsCreateResponse.class);
    }

    @Override
    public GroupsCreateResponse createGroup(RequestConfigurator<GroupsCreateRequest.GroupsCreateRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.createGroup(req.configure(GroupsCreateRequest.builder()).build());
    }

    @Override
    public GroupsPatchResponse patchGroup(GroupsPatchRequest req) throws IOException, SCIM2ApiException {
        GroupsPatchRequestBody body = GroupsPatchRequestBody.builder().schemas(req.getSchemas()).operations(req.getOperations().stream().map(op -> op.toSerializable()).collect(Collectors.toList())).build();
        return this.doPatch(SCIM2EndpointName.patchGroup, this.getGroupsResourceURL() + "/" + req.getId(), body, this.getToken(req), GroupsPatchResponse.class);
    }

    @Override
    public GroupsPatchResponse patchGroup(RequestConfigurator<GroupsPatchRequest.GroupsPatchRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.patchGroup(req.configure(GroupsPatchRequest.builder()).build());
    }

    @Override
    public GroupsUpdateResponse updateGroup(GroupsUpdateRequest req) throws IOException, SCIM2ApiException {
        return this.doPut(SCIM2EndpointName.updateGroup, this.getGroupsResourceURL() + "/" + req.getId(), req.getGroup(), this.getToken(req), GroupsUpdateResponse.class);
    }

    @Override
    public GroupsUpdateResponse updateGroup(RequestConfigurator<GroupsUpdateRequest.GroupsUpdateRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.updateGroup(req.configure(GroupsUpdateRequest.builder()).build());
    }

    @Override
    public GroupsDeleteResponse deleteGroup(GroupsDeleteRequest req) throws IOException, SCIM2ApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getGroupsResourceURL() + "/" + req.getId());
        return this.doDelete(SCIM2EndpointName.deleteGroup, requestBuilder, GroupsDeleteResponse.class);
    }

    @Override
    public GroupsDeleteResponse deleteGroup(RequestConfigurator<GroupsDeleteRequest.GroupsDeleteRequestBuilder> req) throws IOException, SCIM2ApiException {
        return this.deleteGroup(req.configure(GroupsDeleteRequest.builder()).build());
    }

    private String getToken(SCIM2ApiRequest req) {
        if (req.getToken() != null) {
            return req.getToken();
        }
        if (this.token != null) {
            return this.token;
        }
        throw new IllegalStateException("Slack OAuth token is missing! Set token in either SCIMClient or request object.");
    }

    private Request.Builder withAuthorizationHeader(Request.Builder req, String token) {
        return req.addHeader("Authorization", "Bearer " + token);
    }

    private String getUsersResourceURL() {
        return this.endpointUrlPrefix + "Users";
    }

    private String getGroupsResourceURL() {
        return this.endpointUrlPrefix + "Groups";
    }

    private String getEnterpriseIdForMetrics() {
        String enterpriseId = null;
        if (this.config.isStatsEnabled()) {
            enterpriseId = this.teamIdCache.lookupOrResolve(this.token);
        }
        return enterpriseId;
    }

    private <T> T handle(SCIM2EndpointName name, Class<T> clazz, Supplier<Response> performRequest) throws IOException, SCIM2ApiException {
        String enterpriseId = this.getEnterpriseIdForMetrics();
        MetricsDatastore datastore = this.config.getMetricsDatastore();
        try {
            Response response = performRequest.get();
            T result = this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
            if (enterpriseId != null) {
                datastore.incrementSuccessfulCalls(this.executorName, enterpriseId, name.name());
            }
            T t = result;
            return t;
        }
        catch (SCIM2ApiException e) {
            String retryAfterSeconds;
            if (enterpriseId != null) {
                datastore.incrementUnsuccessfulCalls(this.executorName, enterpriseId, name.name());
            }
            if (e.getResponse().code() == 429 && (retryAfterSeconds = e.getResponse().header("Retry-After")) != null) {
                long secondsToWait = Long.valueOf(retryAfterSeconds);
                long epochMillisToRetry = System.currentTimeMillis() + secondsToWait * 1000L;
                if (enterpriseId != null) {
                    datastore.setRateLimitedMethodRetryEpochMillis(this.executorName, enterpriseId, name.name(), epochMillisToRetry);
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (enterpriseId != null) {
                datastore.incrementFailedCalls(this.executorName, enterpriseId, name.name());
            }
            if (e.getCause() instanceof IOException) {
                IOException ioe = (IOException)e.getCause();
                throw ioe;
            }
            throw e;
        }
        finally {
            if (enterpriseId != null) {
                datastore.incrementAllCompletedCalls(this.executorName, enterpriseId, name.name());
                datastore.addToLastMinuteRequests(this.executorName, enterpriseId, name.name(), System.currentTimeMillis());
            }
        }
    }

    private <T> T doGet(SCIM2EndpointName name, String url, Map<String, String> query, String token, Class<T> clazz) throws IOException, SCIM2ApiException {
        return this.handle(name, clazz, () -> {
            try {
                return this.slackHttpClient.get(url, query, token);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T doPost(SCIM2EndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIM2ApiException {
        return this.handle(name, clazz, () -> {
            try {
                return this.slackHttpClient.postCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T doPatch(SCIM2EndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIM2ApiException {
        return this.handle(name, clazz, () -> {
            try {
                return this.slackHttpClient.patchCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T doPut(SCIM2EndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIM2ApiException {
        return this.handle(name, clazz, () -> {
            try {
                return this.slackHttpClient.putCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T doDelete(SCIM2EndpointName name, Request.Builder requestBuilder, Class<T> clazz) throws IOException, SCIM2ApiException {
        return this.handle(name, clazz, () -> {
            try {
                return this.slackHttpClient.delete(requestBuilder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T parseCamelCaseJsonResponseAndRunListeners(Response response, Class<T> clazz) throws IOException, SCIM2ApiException {
        String body = response.body().string();
        try {
            if (response.isSuccessful()) {
                Object object = GsonFactory.createCamelCase(this.slackHttpClient.getConfig()).fromJson(body, clazz);
                return (T)object;
            }
            throw new SCIM2ApiException(this.slackHttpClient.getConfig(), response, body);
        }
        finally {
            this.slackHttpClient.runHttpResponseListeners(response, body);
        }
    }

    public static class GroupsPatchRequestBody {
        private List<String> schemas;
        @SerializedName(value="Operations")
        private List<GroupsPatchOperation.Serializable> operations;

        @Generated
        GroupsPatchRequestBody(List<String> schemas, List<GroupsPatchOperation.Serializable> operations) {
            this.schemas = schemas;
            this.operations = operations;
        }

        @Generated
        public static GroupsPatchRequestBodyBuilder builder() {
            return new GroupsPatchRequestBodyBuilder();
        }

        @Generated
        public List<String> getSchemas() {
            return this.schemas;
        }

        @Generated
        public List<GroupsPatchOperation.Serializable> getOperations() {
            return this.operations;
        }

        @Generated
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @Generated
        public void setOperations(List<GroupsPatchOperation.Serializable> operations) {
            this.operations = operations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupsPatchRequestBody)) {
                return false;
            }
            GroupsPatchRequestBody other = (GroupsPatchRequestBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$schemas = this.getSchemas();
            List<String> other$schemas = other.getSchemas();
            if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
                return false;
            }
            List<GroupsPatchOperation.Serializable> this$operations = this.getOperations();
            List<GroupsPatchOperation.Serializable> other$operations = other.getOperations();
            return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupsPatchRequestBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $schemas = this.getSchemas();
            result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
            List<GroupsPatchOperation.Serializable> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SCIM2ClientImpl.GroupsPatchRequestBody(schemas=" + this.getSchemas() + ", operations=" + this.getOperations() + ")";
        }

        @Generated
        public static class GroupsPatchRequestBodyBuilder {
            @Generated
            private List<String> schemas;
            @Generated
            private List<GroupsPatchOperation.Serializable> operations;

            @Generated
            GroupsPatchRequestBodyBuilder() {
            }

            @Generated
            public GroupsPatchRequestBodyBuilder schemas(List<String> schemas) {
                this.schemas = schemas;
                return this;
            }

            @Generated
            public GroupsPatchRequestBodyBuilder operations(List<GroupsPatchOperation.Serializable> operations) {
                this.operations = operations;
                return this;
            }

            @Generated
            public GroupsPatchRequestBody build() {
                return new GroupsPatchRequestBody(this.schemas, this.operations);
            }

            @Generated
            public String toString() {
                return "SCIM2ClientImpl.GroupsPatchRequestBody.GroupsPatchRequestBodyBuilder(schemas=" + this.schemas + ", operations=" + this.operations + ")";
            }
        }
    }

    public static class UsersPatchRequestBody {
        private List<String> schemas;
        @SerializedName(value="Operations")
        private List<UsersPatchOperation.Serializable> operations;

        @Generated
        UsersPatchRequestBody(List<String> schemas, List<UsersPatchOperation.Serializable> operations) {
            this.schemas = schemas;
            this.operations = operations;
        }

        @Generated
        public static UsersPatchRequestBodyBuilder builder() {
            return new UsersPatchRequestBodyBuilder();
        }

        @Generated
        public List<String> getSchemas() {
            return this.schemas;
        }

        @Generated
        public List<UsersPatchOperation.Serializable> getOperations() {
            return this.operations;
        }

        @Generated
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @Generated
        public void setOperations(List<UsersPatchOperation.Serializable> operations) {
            this.operations = operations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsersPatchRequestBody)) {
                return false;
            }
            UsersPatchRequestBody other = (UsersPatchRequestBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$schemas = this.getSchemas();
            List<String> other$schemas = other.getSchemas();
            if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
                return false;
            }
            List<UsersPatchOperation.Serializable> this$operations = this.getOperations();
            List<UsersPatchOperation.Serializable> other$operations = other.getOperations();
            return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsersPatchRequestBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $schemas = this.getSchemas();
            result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
            List<UsersPatchOperation.Serializable> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SCIM2ClientImpl.UsersPatchRequestBody(schemas=" + this.getSchemas() + ", operations=" + this.getOperations() + ")";
        }

        @Generated
        public static class UsersPatchRequestBodyBuilder {
            @Generated
            private List<String> schemas;
            @Generated
            private List<UsersPatchOperation.Serializable> operations;

            @Generated
            UsersPatchRequestBodyBuilder() {
            }

            @Generated
            public UsersPatchRequestBodyBuilder schemas(List<String> schemas) {
                this.schemas = schemas;
                return this;
            }

            @Generated
            public UsersPatchRequestBodyBuilder operations(List<UsersPatchOperation.Serializable> operations) {
                this.operations = operations;
                return this;
            }

            @Generated
            public UsersPatchRequestBody build() {
                return new UsersPatchRequestBody(this.schemas, this.operations);
            }

            @Generated
            public String toString() {
                return "SCIM2ClientImpl.UsersPatchRequestBody.UsersPatchRequestBodyBuilder(schemas=" + this.schemas + ", operations=" + this.operations + ")";
            }
        }
    }
}

