/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.util;

import com.simsilica.mathd.util.FixedIntRange;
import com.simsilica.mathd.util.IntRange;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntRangeSet
extends AbstractSet<Integer> {
    private Span head;

    public IntRange[] toRangeArray() {
        int count = 0;
        Span span = this.head;
        while (span != null) {
            ++count;
            span = span.next;
        }
        IntRange[] result = new IntRange[count];
        int index = 0;
        Span span2 = this.head;
        while (span2 != null) {
            result[index++] = new FixedIntRange(span2.getMinValue(), span2.getMaxValue());
            span2 = span2.next;
        }
        return result;
    }

    public Iterator<IntRange> rangeIterator() {
        return new RangeIterator(this.head);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerIterator(this.head);
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public void clear() {
        this.head = null;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.contains((Integer)o);
        }
        return false;
    }

    public boolean contains(int value) {
        Span span = this.head;
        while (span != null) {
            if (span.contains(value)) {
                return true;
            }
            span = span.next;
        }
        return false;
    }

    @Override
    public int size() {
        int total = 0;
        Span span = this.head;
        while (span != null) {
            total += span.size;
            span = span.next;
        }
        return total;
    }

    @Override
    public boolean add(Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot add nulls");
        }
        return this.add((int)value);
    }

    @Override
    public boolean remove(Object value) {
        if (value instanceof Integer) {
            return this.remove((Integer)value);
        }
        if (value == null) {
            throw new NullPointerException("Cannot add nulls");
        }
        return false;
    }

    @Override
    public boolean add(int value) {
        Span insert;
        if (this.head == null) {
            this.head = new Span(value);
            return true;
        }
        Span prev = null;
        Span span = this.head;
        while (span != null) {
            if (value < span.min - 1) {
                Span insert2 = new Span(value);
                insert2.next = span;
                if (prev == null) {
                    this.head = insert2;
                } else {
                    prev.next = insert2;
                }
                return true;
            }
            if (value == span.min - 1) {
                span.min = value;
                ++span.size;
                return true;
            }
            if (span.contains(value)) {
                return false;
            }
            if (value == span.min + span.size) {
                ++span.size;
                if (span.next != null && value == span.next.min - 1) {
                    span.size += span.next.size;
                    span.next = span.next.next;
                }
                return true;
            }
            prev = span;
            span = span.next;
        }
        prev.next = insert = new Span(value);
        return true;
    }

    public boolean remove(int i) {
        if (this.head == null) {
            return false;
        }
        Span prev = null;
        Span span = this.head;
        while (span != null) {
            if (i < span.min) {
                return false;
            }
            if (span.contains(i)) {
                if (span.min == i) {
                    if (span.size > 1) {
                        ++span.min;
                        --span.size;
                        return true;
                    }
                    if (prev == null) {
                        this.head = span.next;
                    } else {
                        prev.next = span.next;
                    }
                    return true;
                }
                if (span.getMaxValue() == i) {
                    --span.size;
                    return true;
                }
                Span right = new Span(i + 1, span.getMaxValue());
                right.next = span.next;
                span.setMaxValue(i - 1);
                span.next = right;
                return true;
            }
            prev = span;
            span = span.next;
        }
        return false;
    }

    public boolean remove(IntRange range) {
        return this.remove(range.getMinValue(), range.getMaxValue());
    }

    public boolean remove(int min, int max) {
        if (this.head == null) {
            return false;
        }
        boolean removed = false;
        Span prev = null;
        Span span = this.head;
        while (span != null) {
            if (max < span.min) {
                return removed;
            }
            if (min <= span.min && max >= span.getMaxValue()) {
                if (prev == null) {
                    this.head = span.next;
                } else {
                    prev.next = span.next;
                }
                if (max == span.getMaxValue()) {
                    return true;
                }
                removed = true;
            } else {
                if (min <= span.min && span.contains(max)) {
                    span.setRange(max + 1, span.getMaxValue());
                    return true;
                }
                if (span.contains(min) && max >= span.getMaxValue()) {
                    span.setRange(span.min, min - 1);
                    removed = true;
                } else if (span.contains(min) && span.contains(max)) {
                    Span right = new Span(max + 1, span.getMaxValue());
                    right.next = span.next;
                    span.setMaxValue(min - 1);
                    span.next = right;
                    return true;
                }
            }
            prev = span;
            span = span.next;
        }
        return removed;
    }

    private class RangeIterator
    implements Iterator<IntRange> {
        private Span current;

        public RangeIterator(Span current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public IntRange next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Span result = this.current;
            this.current = this.current.next;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class IntegerIterator
    implements Iterator<Integer> {
        private Span current;
        private Integer nextValue;

        public IntegerIterator(Span start) {
            this.current = start;
            this.fetch();
        }

        protected void fetch() {
            if (this.current == null) {
                this.nextValue = null;
                return;
            }
            if (this.nextValue == null) {
                this.nextValue = this.current.min;
                return;
            }
            int next = this.nextValue + 1;
            if (this.current.contains(next)) {
                this.nextValue = next;
                return;
            }
            this.current = this.current.next;
            this.nextValue = null;
            this.fetch();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public Integer next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            Integer result = this.nextValue;
            this.fetch();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Span
    implements IntRange {
        Span next;
        int min;
        int size;

        public Span(int min) {
            this.min = min;
            this.size = 1;
        }

        public Span(int min, int max) {
            this.min = min;
            this.size = max - min + 1;
        }

        public void setRange(int min, int max) {
            this.min = min;
            this.size = max - min + 1;
        }

        protected void setMaxValue(int max) {
            this.size = max - this.min + 1;
        }

        protected boolean contains(int value) {
            if (value < this.min) {
                return false;
            }
            return value <= this.getMaxValue();
        }

        @Override
        public int getMinValue() {
            return this.min;
        }

        @Override
        public int getMaxValue() {
            return this.min + this.size - 1;
        }

        @Override
        public int getLength() {
            return this.size;
        }

        public String toString() {
            return "Range[" + this.getMinValue() + ":" + this.getMaxValue() + "]";
        }
    }
}

