/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.trans;

import com.simsilica.mathd.trans.Transition;
import java.util.Arrays;

public class TransitionBuffer<T extends Transition> {
    private final Transition[] array;
    private int count;
    private volatile int head = 0;
    private volatile int tail = 0;

    public TransitionBuffer(int size) {
        this.array = new Transition[size + 1];
    }

    public int getSize() {
        return this.array.length - 1;
    }

    public void addTransition(T transition) {
        int nextTail = this.next(this.tail);
        if (nextTail == this.head) {
            this.array[this.head] = null;
            this.head = this.next(this.head);
        }
        if (this.count == 0) {
            this.array[this.tail] = transition;
        } else {
            Transition last = this.array[this.previous(this.tail)];
            transition.setPreviousTransition((Transition)last);
            this.array[this.tail] = transition;
        }
        this.tail = nextTail;
        if (this.count < this.array.length - 1) {
            ++this.count;
        }
    }

    public boolean isFilled() {
        return this.count == this.array.length - 1;
    }

    private int next(int index) {
        return (index + 1) % this.array.length;
    }

    private int previous(int index) {
        if (index > 0) {
            return index - 1;
        }
        return this.array.length - 1;
    }

    public T getTransition(long time) {
        return this.getTransition(time, true);
    }

    public T getTransition(long time, boolean clamp) {
        int h = this.head;
        int t = this.tail;
        if (h == t && this.count > 0) {
            System.err.println("**** TimeBuffer inconsistency.  This shouldn't happen.");
        }
        Transition last = null;
        int i = h;
        while (i != t) {
            Transition ft = this.array[i];
            if (ft == null) {
                System.out.println("element is null:" + i + "  head:" + h + " tail:" + t);
            } else {
                if (time < ft.getStartTime()) {
                    if (clamp) {
                        return (T)ft;
                    }
                    return null;
                }
                if (time <= ft.getEndTime()) {
                    return (T)ft;
                }
                last = ft;
            }
            i = this.next(i);
        }
        if (clamp) {
            return (T)last;
        }
        return null;
    }

    public String toString() {
        return "TransitionBuffer[ h:" + this.head + ", t:" + this.tail + ", array:" + Arrays.asList(this.array) + "]";
    }
}

