/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.trans;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.Transition;
import com.simsilica.mathd.trans.TransitionBuffer;

public class PositionTransition3d
implements Transition<PositionTransition3d> {
    private long startTime;
    private Vec3d startPos;
    private Quatd startRot;
    private boolean startVisible;
    private final long endTime;
    private final Vec3d endPos;
    private final Quatd endRot;
    private final boolean endVisible;

    public PositionTransition3d(long endTime, Vec3d endPos, Quatd endRot, boolean visible) {
        this.endTime = endTime;
        this.endPos = endPos;
        this.endRot = endRot;
        this.endVisible = visible;
    }

    public static TransitionBuffer<PositionTransition3d> createBuffer(int history) {
        return new TransitionBuffer<PositionTransition3d>(history);
    }

    @Override
    public void setPreviousTransition(PositionTransition3d previous) {
        this.startTime = previous.endTime;
        this.startPos = previous.endPos;
        this.startRot = previous.endRot;
        this.startVisible = previous.endVisible;
        if (this.startTime > this.endTime) {
            throw new IllegalArgumentException("Frame transitions cannot go backwards.");
        }
    }

    @Override
    public boolean containsTime(long time) {
        if (time < this.startTime) {
            return false;
        }
        return time <= this.endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    protected final double tween(long time) {
        long length = this.endTime - this.startTime;
        if (length == 0L) {
            return 0.0;
        }
        double part = time - this.startTime;
        if (part > (double)length) {
            return 1.0;
        }
        if (part < 0.0) {
            return 0.0;
        }
        return part / (double)length;
    }

    public Vec3d getPosition(long time) {
        return this.getPosition(time, false);
    }

    public Vec3d getPosition(long time, boolean clamp) {
        if (this.startPos == null) {
            return clamp ? this.endPos.clone() : null;
        }
        if (time < this.startTime) {
            return clamp ? this.startPos.clone() : null;
        }
        double t = this.tween(time);
        Vec3d result = new Vec3d().interpolateLocal(this.startPos, this.endPos, t);
        return result;
    }

    public Quatd getRotation(long time) {
        return this.getRotation(time, false);
    }

    public Quatd getRotation(long time, boolean clamp) {
        if (this.startRot == null) {
            return clamp ? this.endRot.clone() : null;
        }
        if (time < this.startTime) {
            return clamp ? this.startRot.clone() : null;
        }
        Quatd result = new Quatd().slerpLocal(this.startRot, this.endRot, this.tween(time));
        return result;
    }

    public boolean getVisibility(long time) {
        if (time > this.endTime) {
            return this.endVisible;
        }
        return this.startVisible;
    }

    public Vec3d getStartPosition() {
        return this.startPos;
    }

    public Vec3d getEndPosition() {
        return this.endPos;
    }

    public Quatd getStartRotation() {
        return this.startRot;
    }

    public Quatd getEndRotation() {
        return this.endRot;
    }

    public boolean getStartVisibility() {
        return this.startVisible;
    }

    public boolean getEndVisibility() {
        return this.endVisible;
    }

    public String toString() {
        return "PositionTransition3d[ t:" + this.startTime + ", pos:" + this.startPos + ", rot:" + this.startRot + ", vis:" + this.startVisible + " -> t:" + this.endTime + ", pos:" + this.endPos + ", rot:" + this.endRot + ", vis:" + this.endVisible + " ]";
    }
}

