/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.bits;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.bits.FloatBits;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Vec3Bits {
    static Logger log = LoggerFactory.getLogger(Vec3Bits.class);
    private final FloatBits xBits;
    private final FloatBits yBits;
    private final int yShift;
    private final FloatBits zBits;
    private final int zShift;
    private final int totalBits;
    private final long mask;

    public Vec3Bits(float minValue, float maxValue, int bitSize) {
        this(new FloatBits(minValue, maxValue, bitSize), new FloatBits(minValue, maxValue, bitSize), new FloatBits(minValue, maxValue, bitSize));
    }

    public Vec3Bits(FloatBits xBits, FloatBits yBits, FloatBits zBits) {
        this.xBits = xBits;
        this.yShift = xBits.getBitSize();
        this.yBits = yBits;
        this.zShift = this.yShift + yBits.getBitSize();
        this.zBits = zBits;
        this.totalBits = this.zShift + zBits.getBitSize();
        if (this.totalBits > 64) {
            throw new IllegalArgumentException("Total bit size exceeds 64");
        }
        long temp = xBits.getMask();
        temp |= yBits.getMask() << this.yShift;
        this.mask = temp |= zBits.getMask() << this.zShift;
        log.debug("Bit size:" + this.totalBits + "  mask:" + Long.toHexString(this.mask));
    }

    public FloatBits getXBits() {
        return this.xBits;
    }

    public FloatBits getYBits() {
        return this.yBits;
    }

    public FloatBits getZBits() {
        return this.zBits;
    }

    public int getBitSize() {
        return this.totalBits;
    }

    public long getMask() {
        return this.mask;
    }

    public long toBits(Vec3d v) {
        long x = this.xBits.toBits((float)v.x);
        long y = this.yBits.toBits((float)v.y);
        long z = this.zBits.toBits((float)v.z);
        long result = x;
        result |= y << this.yShift;
        return result |= z << this.zShift;
    }

    public Vec3d fromBits(long bits) {
        long x = bits & this.xBits.getMask();
        long y = bits >> this.yShift & this.yBits.getMask();
        long z = bits >> this.zShift & this.zBits.getMask();
        float xf = this.xBits.fromBits(x);
        float yf = this.yBits.fromBits(y);
        float zf = this.zBits.fromBits(z);
        return new Vec3d(xf, yf, zf);
    }

    public static void main(String ... args) {
        FloatBits float16 = new FloatBits(-35.6f, 35.6f, 16);
        FloatBits float18 = new FloatBits(0.0f, 256.0f, 18);
        Vec3Bits posBits = new Vec3Bits(float16, float18, float16);
        Random rand = new Random(1L);
        float range16 = 71.2f;
        for (int i = 0; i < 10; ++i) {
            float x = rand.nextFloat() * range16 - 35.6f;
            float y = rand.nextFloat() * 256.0f;
            float z = rand.nextFloat() * range16 - 35.6f;
            Vec3d v = new Vec3d(x, y, z);
            long bits = posBits.toBits(v);
            Vec3d rev = posBits.fromBits(bits);
            System.out.println("pos:" + v + "   bits:" + Long.toHexString(bits) + "\nrev:" + rev + "\nerr:" + rev.subtract(v));
        }
    }
}

