/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Ray;
import com.simsilica.mathd.Vec3d;
import java.io.Serializable;
import java.util.Objects;

public class Rayd
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    private Vec3d origin;
    private Vec3d direction;

    protected Rayd() {
    }

    public Rayd(Vec3d origin, Vec3d direction) {
        this.setOrigin(origin);
        this.setDirection(direction);
    }

    public Rayd(Ray ray) {
        this(new Vec3d(ray.origin), new Vec3d(ray.direction));
    }

    public final void setOrigin(Vec3d origin) {
        if (origin == null) {
            throw new IllegalArgumentException("Origin cannot be null");
        }
        this.origin = origin;
    }

    public final Vec3d getOrigin() {
        return this.origin;
    }

    public final void setDirection(Vec3d direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Direction cannot be null");
        }
        if (Math.abs(direction.lengthSq() - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException("Direction is not of unit length:" + direction + "  lengthSq:" + direction.lengthSq());
        }
        this.direction = direction;
    }

    public final Vec3d getDirection() {
        return this.direction;
    }

    public final Rayd set(Vec3d origin, Vec3d direction) {
        this.setOrigin(origin);
        this.setDirection(direction);
        return this;
    }

    public final Rayd set(Rayd r) {
        return this.set(r.origin.clone(), r.direction.clone());
    }

    public final Rayd set(Ray r) {
        return this.set(new Vec3d(r.origin), new Vec3d(r.direction));
    }

    public final Rayd clone() {
        return new Rayd(this.origin.clone(), this.direction.clone());
    }

    public Ray toRay() {
        return new Ray(this.origin.toVector3f(), this.direction.toVector3f());
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.direction);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Rayd other = (Rayd)o;
        if (!Objects.equals(other.direction, this.direction)) {
            return false;
        }
        return Objects.equals(other.origin, this.origin);
    }

    public boolean isSimilar(Rayd other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (!this.origin.isSimilar(other.origin, epsilon)) {
            return false;
        }
        return this.direction.isSimilar(other.direction, epsilon);
    }

    public Vec3d project(double distance, Vec3d target) {
        if (target == null) {
            target = new Vec3d(this.direction);
        } else {
            target.set(this.direction);
        }
        target.multLocal(distance);
        target.addLocal(this.origin);
        return target;
    }

    public Vec3d getClosestPoint(Vec3d point, double limit, Vec3d target) {
        if (target == null) {
            target = new Vec3d(point).subtractLocal(this.origin);
        } else {
            target.set(point).subtractLocal(this.origin);
        }
        double proj = this.direction.dot(target);
        if (limit > 0.0) {
            proj = Math.min(proj, limit);
        }
        if (proj > 0.0) {
            target.set(this.direction).multLocal(proj).addLocal(this.origin);
        } else {
            target.set(this.origin);
        }
        return target;
    }

    public double distanceSq(Vec3d point, double limit) {
        return this.getClosestPoint(point, limit, null).distanceSq(point);
    }

    public double intersectSphere(double limit, Vec3d center, double radius, boolean outsideOnly) {
        Vec3d relative = center.subtract(this.origin);
        double proj = relative.dot(this.direction);
        if (outsideOnly && proj < 0.0) {
            return -1.0;
        }
        if (proj < -radius) {
            return -1.0;
        }
        if (limit > 0.0 && proj > limit + radius) {
            return -1.0;
        }
        double distSq = relative.lengthSq();
        double bSq = distSq - proj * proj;
        if (bSq == 0.0) {
            if (proj < 0.0) {
                return -1.0;
            }
            if (proj > limit) {
                return -1.0;
            }
            return proj;
        }
        double a = Math.sqrt(radius * radius - bSq);
        double best = proj - a;
        if (best < 0.0) {
            if (outsideOnly) {
                return -1.0;
            }
            best = proj + a;
        }
        if (best < 0.0) {
            return -1.0;
        }
        if (limit > 0.0 && best > limit) {
            return -1.0;
        }
        return best;
    }

    public String toString() {
        return "Rayd[origin:" + this.origin + ", direction:" + this.direction + "]";
    }
}

