/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.io.Serializable;
import java.util.Objects;

public class GridCell
implements Serializable {
    static final long serialVersionUID = 42L;
    private final Grid grid;
    private final Vec3i cell;
    private final Vec3i worldOrigin;

    public GridCell(Grid grid, Vec3i cell) {
        this.grid = grid;
        this.cell = cell;
        this.worldOrigin = grid.cellToWorld(cell);
    }

    public final long getId() {
        return this.grid.cellToId(this.cell);
    }

    public final Grid getGrid() {
        return this.grid;
    }

    public final Vec3i getCell() {
        return this.cell;
    }

    public final Vec3i getWorldOrigin() {
        return this.worldOrigin;
    }

    public final boolean contains(Vec3d world) {
        return this.contains(world.x, world.y, world.z);
    }

    public final boolean contains(double x, double y, double z) {
        Vec3i spacing = this.grid.getSpacing();
        double xLocal = x - (double)this.worldOrigin.x;
        double yLocal = y - (double)this.worldOrigin.y;
        double zLocal = z - (double)this.worldOrigin.z;
        if (spacing.x != 0 && (xLocal < 0.0 || xLocal >= (double)spacing.x)) {
            return false;
        }
        if (spacing.y != 0 && (yLocal < 0.0 || yLocal >= (double)spacing.y)) {
            return false;
        }
        return spacing.z == 0 || !(zLocal < 0.0) && !(zLocal >= (double)spacing.z);
    }

    public final Vec3d localToWorld(Vec3d local) {
        return this.localToWorld(local, new Vec3d());
    }

    public final Vec3d localToWorld(Vec3d local, Vec3d store) {
        if (store == null) {
            store = new Vec3d();
        }
        store.x = (double)this.worldOrigin.x + local.x;
        store.y = (double)this.worldOrigin.y + local.y;
        store.z = (double)this.worldOrigin.z + local.z;
        return store;
    }

    public final Vec3i localToWorld(Vec3i local) {
        return this.localToWorld(local, new Vec3i());
    }

    public final Vec3i localToWorld(Vec3i local, Vec3i store) {
        if (store == null) {
            store = new Vec3i();
        }
        store.x = this.worldOrigin.x + local.x;
        store.y = this.worldOrigin.y + local.y;
        store.z = this.worldOrigin.z + local.z;
        return store;
    }

    public final Vec3d worldToLocal(Vec3d world) {
        return this.worldToLocal(world, null);
    }

    public final Vec3d worldToLocal(Vec3d world, Vec3d store) {
        if (store == null) {
            store = new Vec3d();
        }
        store.x = world.x - (double)this.worldOrigin.x;
        store.y = world.y - (double)this.worldOrigin.y;
        store.z = world.z - (double)this.worldOrigin.z;
        return store;
    }

    public final Vec3d worldToLocal(double x, double y, double z) {
        return this.worldToLocal(x, y, z, null);
    }

    public final Vec3d worldToLocal(double x, double y, double z, Vec3d store) {
        if (store == null) {
            store = new Vec3d();
        }
        store.x = x - (double)this.worldOrigin.x;
        store.y = y - (double)this.worldOrigin.y;
        store.z = z - (double)this.worldOrigin.z;
        return store;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GridCell other = (GridCell)o;
        return other.cell.x == this.cell.x && other.cell.y == this.cell.y && other.cell.z == this.cell.z && Objects.equals(other.grid, this.grid);
    }

    public int hashCode() {
        return this.cell.hashCode();
    }

    public String toString() {
        return "(" + this.cell.x + ":" + this.cell.y + ":" + this.cell.z + ")";
    }
}

