/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

final class WrappedJsonAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;
    private final String[] path;
    private final boolean failOnNotFound;

    WrappedJsonAdapter(JsonAdapter<T> delegate, String[] path, boolean failOnNotFound) {
        this.delegate = delegate;
        this.path = path;
        this.failOnNotFound = failOnNotFound;
    }

    public T fromJson(JsonReader reader) throws IOException {
        return WrappedJsonAdapter.fromJson(this.delegate, reader, this.path, 0, this.failOnNotFound);
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        WrappedJsonAdapter.toJson(this.delegate, writer, value, this.path, 0);
    }

    public String toString() {
        return this.delegate + String.format(".wrapped(%s)", Arrays.asList(this.path)) + (this.failOnNotFound ? ".failOnNotFound()" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T fromJson(JsonAdapter<T> adapter, JsonReader reader, String[] path, int index, boolean failOnNotFound) throws IOException {
        if (index == path.length) {
            return (T)adapter.fromJson(reader);
        }
        reader.beginObject();
        Exception caughtException = null;
        try {
            String root = path[index];
            while (reader.hasNext()) {
                if (reader.nextName().equals(root)) {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        if (failOnNotFound) {
                            throw new JsonDataException(String.format("Wrapped Json expected at path: %s. Found null at %s", Arrays.asList(path), reader.getPath()));
                        }
                        Object object = reader.nextNull();
                        return (T)object;
                    }
                    T t = WrappedJsonAdapter.fromJson(adapter, reader, path, ++index, failOnNotFound);
                    return t;
                }
                reader.skipValue();
            }
        }
        catch (Exception e) {
            caughtException = e;
        }
        finally {
            if (caughtException instanceof IOException) {
                throw (IOException)caughtException;
            }
            if (caughtException instanceof JsonDataException) {
                throw (JsonDataException)((Object)caughtException);
            }
            if (caughtException != null) {
                throw new AssertionError((Object)caughtException);
            }
            while (reader.hasNext()) {
                reader.skipValue();
            }
            reader.endObject();
        }
        throw new JsonDataException(String.format("Wrapped Json expected at path: %s. Actual: %s", Arrays.asList(path), reader.getPath()));
    }

    private static <T> void toJson(JsonAdapter<T> adapter, JsonWriter writer, T value, String[] path, int index) throws IOException {
        if (value != null || writer.getSerializeNulls()) {
            if (index == path.length) {
                adapter.toJson(writer, value);
            } else {
                writer.beginObject();
                writer.name(path[index]);
                WrappedJsonAdapter.toJson(adapter, writer, value, path, ++index);
                writer.endObject();
            }
        } else {
            writer.nullValue();
        }
    }
}

