/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

final class SerializeOnlyNonEmptyJsonAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;

    SerializeOnlyNonEmptyJsonAdapter(JsonAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public T fromJson(JsonReader reader) throws IOException {
        return (T)this.delegate.fromJson(reader);
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        if (this.isNotEmpty(value)) {
            this.delegate.toJson(writer, value);
        } else {
            this.delegate.toJson(writer, null);
        }
    }

    private boolean isNotEmpty(T value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.size() > 0;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.size() > 0;
        }
        if (value != null) {
            return Array.getLength(value) > 0;
        }
        return false;
    }

    public String toString() {
        return this.delegate + ".serializeOnlyNonEmpty()";
    }
}

