/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.serjltt.moshi.adapters.FallbackOnNullJsonAdapter;
import com.serjltt.moshi.adapters.Pair;
import com.serjltt.moshi.adapters.Util;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Set;

@Documented
@JsonQualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface FallbackOnNull {
    public static final JsonAdapter.Factory ADAPTER_FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Pair<FallbackOnNull, Set<Annotation>> nextAnnotations = Util.nextAnnotations(annotations, FallbackOnNull.class);
            if (nextAnnotations == null) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (!FallbackOnNullJsonAdapter.PRIMITIVE_CLASSES.contains(rawType)) {
                return null;
            }
            String fallbackType = this.fallbackType(rawType);
            Object fallback = this.retrieveFallback((FallbackOnNull)nextAnnotations.first, fallbackType);
            return new FallbackOnNullJsonAdapter<Object>(moshi.adapter(type, (Set)nextAnnotations.second), fallback, fallbackType);
        }

        private Object retrieveFallback(FallbackOnNull annotation, String fallbackType) {
            try {
                Method fallbackMethod = FallbackOnNull.class.getMethod(fallbackType, new Class[0]);
                return fallbackMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        private String fallbackType(Class<?> rawType) {
            String typeName = rawType.getSimpleName();
            String methodSuffix = typeName.substring(0, 1).toUpperCase(Locale.US) + typeName.substring(1);
            return "fallback" + methodSuffix;
        }
    };

    public boolean fallbackBoolean() default false;

    public byte fallbackByte() default -128;

    public char fallbackChar() default 0;

    public double fallbackDouble() default 4.9E-324;

    public float fallbackFloat() default 1.4E-45f;

    public int fallbackInt() default -2147483648;

    public long fallbackLong() default -9223372036854775808L;

    public short fallbackShort() default -32768;
}

