/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;

final class FallbackEnumJsonAdapter<T extends Enum<T>>
extends JsonAdapter<T> {
    private final Class<T> enumType;
    private final String[] nameStrings;
    private final T[] constants;
    private final JsonReader.Options options;
    private final T fallbackConstant;

    FallbackEnumJsonAdapter(Class<T> enumType, String fallback) {
        this.fallbackConstant = Enum.valueOf(enumType, fallback);
        this.enumType = enumType;
        try {
            this.constants = (Enum[])enumType.getEnumConstants();
            this.nameStrings = new String[this.constants.length];
            for (int i = 0; i < this.constants.length; ++i) {
                String name;
                T constant = this.constants[i];
                Json annotation = enumType.getField(((Enum)constant).name()).getAnnotation(Json.class);
                this.nameStrings[i] = name = annotation != null ? annotation.name() : ((Enum)constant).name();
            }
            this.options = JsonReader.Options.of((String[])this.nameStrings);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T fromJson(JsonReader reader) throws IOException {
        int index = reader.selectString(this.options);
        if (index != -1) {
            return this.constants[index];
        }
        reader.nextString();
        return this.fallbackConstant;
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.value(this.nameStrings[((Enum)value).ordinal()]);
    }

    public String toString() {
        return "JsonAdapter(" + this.enumType.getName() + ").fallbackEnum(" + this.fallbackConstant + ")";
    }
}

