/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

import java.util.List;
import parsii.eval.BinaryFunction;
import parsii.eval.Expression;
import parsii.eval.Function;
import parsii.eval.UnaryFunction;

public class Functions {
    public static final Function SIN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.sin(a);
        }
    };
    public static final Function SINH = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.sinh(a);
        }
    };
    public static final Function COS = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.cos(a);
        }
    };
    public static final Function COSH = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.cosh(a);
        }
    };
    public static final Function TAN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.tan(a);
        }
    };
    public static final Function TANH = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.tanh(a);
        }
    };
    public static final Function ABS = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.abs(a);
        }
    };
    public static final Function ASIN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.asin(a);
        }
    };
    public static final Function ACOS = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.acos(a);
        }
    };
    public static final Function ATAN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.atan(a);
        }
    };
    public static final Function ATAN2 = new BinaryFunction(){

        @Override
        protected double eval(double a, double b) {
            return Math.atan2(a, b);
        }
    };
    public static final Function ROUND = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.round(a);
        }
    };
    public static final Function FLOOR = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.floor(a);
        }
    };
    public static final Function CEIL = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.ceil(a);
        }
    };
    public static final Function POW = new BinaryFunction(){

        @Override
        protected double eval(double a, double b) {
            return Math.pow(a, b);
        }
    };
    public static final Function SQRT = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.sqrt(a);
        }
    };
    public static final Function EXP = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.exp(a);
        }
    };
    public static final Function LN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.log(a);
        }
    };
    public static final Function LOG = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.log10(a);
        }
    };
    public static final Function MIN = new BinaryFunction(){

        @Override
        protected double eval(double a, double b) {
            return Math.min(a, b);
        }
    };
    public static final Function MAX = new BinaryFunction(){

        @Override
        protected double eval(double a, double b) {
            return Math.max(a, b);
        }
    };
    public static final Function RND = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.random() * a;
        }
    };
    public static final Function SIGN = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.signum(a);
        }
    };
    public static final Function DEG = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.toDegrees(a);
        }
    };
    public static final Function RAD = new UnaryFunction(){

        @Override
        protected double eval(double a) {
            return Math.toRadians(a);
        }
    };
    public static final Function IF = new IfFunction();

    private Functions() {
    }

    private static class IfFunction
    implements Function {
        private IfFunction() {
        }

        @Override
        public int getNumberOfArguments() {
            return 3;
        }

        @Override
        public double eval(List<Expression> args) {
            double check = args.get(0).evaluate();
            if (Double.isNaN(check)) {
                return check;
            }
            if (Math.abs(check) > 0.0) {
                return args.get(1).evaluate();
            }
            return args.get(2).evaluate();
        }

        @Override
        public boolean isNaturalFunction() {
            return false;
        }
    }
}

