/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import parsii.eval.Variable;

public class Scope {
    private Scope parent;
    private Map<String, Variable> context = new ConcurrentHashMap<String, Variable>();
    private static Scope root;

    private Scope() {
    }

    public static Scope create() {
        Scope result = new Scope();
        result.parent = Scope.getRootScope();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Scope getRootScope() {
        if (root != null) return root;
        Class<Scope> clazz = Scope.class;
        synchronized (Scope.class) {
            root = new Scope();
            root.getVariable("pi").makeConstant(Math.PI);
            root.getVariable("euler").makeConstant(Math.E);
            // ** MonitorExit[var0] (shouldn't be in output)
            return root;
        }
    }

    public static Scope createWithParent(Scope parent) {
        Scope result = Scope.create();
        result.parent = parent;
        return result;
    }

    public Variable find(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        if (this.parent != null) {
            return this.parent.find(name);
        }
        return null;
    }

    public Variable getVariable(String name) {
        Variable result = this.find(name);
        if (result != null) {
            return result;
        }
        return this.create(name);
    }

    public Variable create(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        Variable result = new Variable(name);
        this.context.put(name, result);
        return result;
    }

    public Set<String> getLocalNames() {
        return this.context.keySet();
    }

    public Set<String> getNames() {
        if (this.parent == null) {
            return this.getLocalNames();
        }
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.parent.getNames());
        result.addAll(this.getLocalNames());
        return result;
    }

    public Collection<Variable> getLocalVariables() {
        return this.context.values();
    }

    public Collection<Variable> getVariables() {
        if (this.parent == null) {
            return this.getLocalVariables();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        result.addAll(this.parent.getVariables());
        result.addAll(this.getLocalVariables());
        return result;
    }
}

