/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

import parsii.eval.Constant;
import parsii.eval.Expression;

public class BinaryOperation
extends Expression {
    private final Op op;
    private Expression left;
    private Expression right;
    private boolean sealed = false;
    public static final double EPSILON = 1.0E-10;

    public BinaryOperation(Op op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public Op getOp() {
        return this.op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public double evaluate() {
        double a = this.left.evaluate();
        double b = this.right.evaluate();
        if (this.op == Op.ADD) {
            return a + b;
        }
        if (this.op == Op.SUBTRACT) {
            return a - b;
        }
        if (this.op == Op.MULTIPLY) {
            return a * b;
        }
        if (this.op == Op.DIVIDE) {
            return a / b;
        }
        if (this.op == Op.POWER) {
            return Math.pow(a, b);
        }
        if (this.op == Op.MODULO) {
            return a % b;
        }
        if (this.op == Op.LT) {
            return a < b ? 1.0 : 0.0;
        }
        if (this.op == Op.LT_EQ) {
            return a < b || Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
        }
        if (this.op == Op.GT) {
            return a > b ? 1.0 : 0.0;
        }
        if (this.op == Op.GT_EQ) {
            return a > b || Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
        }
        if (this.op == Op.EQ) {
            return Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
        }
        if (this.op == Op.NEQ) {
            return Math.abs(a - b) > 1.0E-10 ? 1.0 : 0.0;
        }
        if (this.op == Op.AND) {
            return a == 1.0 && b == 1.0 ? 1.0 : 0.0;
        }
        if (this.op == Op.OR) {
            return a == 1.0 || b == 1.0 ? 1.0 : 0.0;
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this.op));
    }

    @Override
    public Expression simplify() {
        this.left = this.left.simplify();
        this.right = this.right.simplify();
        if (this.left.isConstant() && this.right.isConstant()) {
            return new Constant(this.evaluate());
        }
        if (this.op == Op.ADD || this.op == Op.MULTIPLY) {
            if (this.right.isConstant()) {
                Expression tmp = this.right;
                this.right = this.left;
                this.left = tmp;
            }
            if (this.right instanceof BinaryOperation) {
                BinaryOperation childOp = (BinaryOperation)this.right;
                if (this.op == childOp.op) {
                    if (this.left.isConstant()) {
                        if (childOp.left.isConstant()) {
                            if (this.op == Op.ADD) {
                                return new BinaryOperation(this.op, new Constant(this.left.evaluate() + childOp.left.evaluate()), childOp.right);
                            }
                            if (this.op == Op.MULTIPLY) {
                                return new BinaryOperation(this.op, new Constant(this.left.evaluate() * childOp.left.evaluate()), childOp.right);
                            }
                        }
                    } else if (childOp.left.isConstant()) {
                        return new BinaryOperation(this.op, childOp.left, new BinaryOperation(this.op, this.left, childOp.right));
                    }
                }
            }
        }
        return super.simplify();
    }

    public String toString() {
        return "(" + this.left.toString() + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }

    public static enum Op {
        ADD(3),
        SUBTRACT(3),
        MULTIPLY(4),
        DIVIDE(4),
        MODULO(4),
        POWER(5),
        LT(2),
        LT_EQ(2),
        EQ(2),
        GT_EQ(2),
        GT(2),
        NEQ(2),
        AND(1),
        OR(1);

        private final int priority;

        public int getPriority() {
            return this.priority;
        }

        private Op(int priority) {
            this.priority = priority;
        }
    }
}

