/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

public class Variable {
    private double value = 0.0;
    private String name;
    private boolean constant = false;

    protected Variable(String name) {
        this.name = name;
    }

    public void setValue(double value) {
        if (this.constant) {
            throw new IllegalStateException(String.format("%s is constant!", this.name));
        }
        this.value = value;
    }

    public void makeConstant(double value) {
        this.setValue(value);
        this.constant = true;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + ": " + String.valueOf(this.value);
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public Variable withValue(double value) {
        this.setValue(value);
        return this;
    }
}

