/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import parsii.eval.Variable;

public class Scope {
    private Scope parent;
    private Map<String, Variable> context = new ConcurrentHashMap<String, Variable>();
    private static Scope root;

    private Scope() {
    }

    public static Scope create() {
        Scope result = new Scope();
        result.parent = Scope.getRootScope();
        return result;
    }

    private static Scope getRootScope() {
        if (root == null) {
            root = new Scope();
            root.getVariable("pi").makeConstant(Math.PI);
            root.getVariable("E").makeConstant(Math.E);
        }
        return root;
    }

    public static Scope createWithParent(Scope parent) {
        Scope result = Scope.create();
        result.parent = parent;
        return result;
    }

    public Variable find(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        if (this.parent != null) {
            return this.parent.find(name);
        }
        return null;
    }

    public Variable getVariable(String name) {
        Variable result = this.find(name);
        if (result != null) {
            return result;
        }
        return this.create(name);
    }

    public Variable create(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        Variable result = new Variable(name);
        this.context.put(name, result);
        return result;
    }
}

