/*
 * Decompiled with CFR 0.152.
 */
package parsii.eval;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import parsii.eval.BinaryOperation;
import parsii.eval.Constant;
import parsii.eval.Expression;
import parsii.eval.Function;
import parsii.eval.FunctionCall;
import parsii.eval.Functions;
import parsii.eval.Scope;
import parsii.eval.VariableReference;
import parsii.tokenizer.ParseError;
import parsii.tokenizer.ParseException;
import parsii.tokenizer.Position;
import parsii.tokenizer.Token;
import parsii.tokenizer.Tokenizer;

public class Parser {
    private final Scope scope;
    private List<ParseError> errors = new ArrayList<ParseError>();
    private Tokenizer tokenizer;
    private static Map<String, Function> functionTable = new TreeMap<String, Function>();

    public static void registerFunction(String name, Function function) {
        functionTable.put(name, function);
    }

    public static Expression parse(String input) throws ParseException {
        return new Parser(new StringReader(input), Scope.create()).parse();
    }

    public static Expression parse(Reader input) throws ParseException {
        return new Parser(input, Scope.create()).parse();
    }

    public static Expression parse(String input, Scope scope) throws ParseException {
        return new Parser(new StringReader(input), scope).parse();
    }

    public static Expression parse(Reader input, Scope scope) throws ParseException {
        return new Parser(input, scope).parse();
    }

    private Parser(Reader input, Scope scope) {
        this.scope = scope;
        this.tokenizer = new Tokenizer(input);
        this.tokenizer.setProblemCollector(this.errors);
    }

    protected Expression parse() throws ParseException {
        Expression result = this.expression().simplify();
        if (this.errors.size() > 0) {
            throw ParseException.create(this.errors);
        }
        return result;
    }

    protected Expression expression() {
        Expression left = this.relationalExpression();
        if (((Token)this.tokenizer.current()).isSymbol("&&")) {
            this.tokenizer.consume();
            Expression right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.AND);
        }
        if (((Token)this.tokenizer.current()).isSymbol("||")) {
            this.tokenizer.consume();
            Expression right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.OR);
        }
        return left;
    }

    protected Expression relationalExpression() {
        Expression left = this.term();
        if (((Token)this.tokenizer.current()).isSymbol("<")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("<=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol("=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("!=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.NEQ);
        }
        return left;
    }

    protected Expression term() {
        Expression left = this.product();
        if (((Token)this.tokenizer.current()).isSymbol("+")) {
            this.tokenizer.consume();
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.ADD);
        }
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.SUBTRACT);
        }
        if (((Token)this.tokenizer.current()).isNumber() && ((Token)this.tokenizer.current()).getContents().startsWith("-")) {
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.ADD);
        }
        return left;
    }

    protected Expression product() {
        Expression left = this.power();
        if (((Token)this.tokenizer.current()).isSymbol("*")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MULTIPLY);
        }
        if (((Token)this.tokenizer.current()).isSymbol("/")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.DIVIDE);
        }
        if (((Token)this.tokenizer.current()).isSymbol("%")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MODULO);
        }
        return left;
    }

    private Expression reOrder(Expression left, Expression right, BinaryOperation.Op op) {
        BinaryOperation rightOp;
        if (right instanceof BinaryOperation && !(rightOp = (BinaryOperation)right).isSealed() && rightOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(rightOp, left, op);
            return right;
        }
        return new BinaryOperation(op, left, right);
    }

    private void replaceLeft(BinaryOperation target, Expression newLeft, BinaryOperation.Op op) {
        BinaryOperation leftOp;
        if (target.getLeft() instanceof BinaryOperation && !(leftOp = (BinaryOperation)target.getLeft()).isSealed() && leftOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(leftOp, newLeft, op);
            return;
        }
        target.setLeft(new BinaryOperation(op, newLeft, target.getLeft()));
    }

    protected Expression power() {
        Expression left = this.atom();
        if (((Token)this.tokenizer.current()).isSymbol("^") || ((Token)this.tokenizer.current()).isSymbol("**")) {
            this.tokenizer.consume();
            Expression right = this.power();
            return this.reOrder(left, right, BinaryOperation.Op.POWER);
        }
        return left;
    }

    protected Expression atom() {
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            BinaryOperation result = new BinaryOperation(BinaryOperation.Op.SUBTRACT, new Constant(0.0), this.atom());
            result.seal();
            return result;
        }
        if (((Token)this.tokenizer.current()).isSymbol("(")) {
            this.tokenizer.consume();
            Expression result = this.expression();
            if (result instanceof BinaryOperation) {
                ((BinaryOperation)result).seal();
            }
            this.expect(Token.TokenType.SYMBOL, ")");
            return result;
        }
        if (((Token)this.tokenizer.current()).isSymbol("|")) {
            this.tokenizer.consume();
            FunctionCall call = new FunctionCall();
            call.addParameter(this.expression());
            call.setFunction(Functions.ABS);
            this.expect(Token.TokenType.SYMBOL, "|");
            return call;
        }
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
            if (((Token)this.tokenizer.next()).isSymbol("(")) {
                return this.functionCall();
            }
            return new VariableReference(this.scope.getVariable(((Token)this.tokenizer.consume()).getContents()));
        }
        if (((Token)this.tokenizer.current()).isNumber()) {
            double value = Double.parseDouble(((Token)this.tokenizer.consume()).getContents());
            if (((Token)this.tokenizer.current()).is(Token.TokenType.ID)) {
                String quantifier = ((Token)this.tokenizer.current()).getContents().intern();
                if ("n" == quantifier) {
                    value /= 1.0E9;
                    this.tokenizer.consume();
                } else if ("u" == quantifier) {
                    value /= 1000000.0;
                    this.tokenizer.consume();
                } else if ("m" == quantifier) {
                    value /= 1000.0;
                    this.tokenizer.consume();
                } else if ("K" == quantifier || "k" == quantifier) {
                    value *= 1000.0;
                    this.tokenizer.consume();
                } else if ("M" == quantifier) {
                    value *= 1000000.0;
                    this.tokenizer.consume();
                } else if ("G" == quantifier) {
                    value *= 1.0E9;
                    this.tokenizer.consume();
                }
            }
            return new Constant(value);
        }
        Token token = (Token)this.tokenizer.consume();
        this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected an expression.", token.getSource())));
        return Constant.EMPTY;
    }

    protected Expression functionCall() {
        FunctionCall call = new FunctionCall();
        Token funToken = (Token)this.tokenizer.consume();
        Function fun = functionTable.get(funToken.getContents());
        if (fun == null) {
            this.errors.add(ParseError.error(funToken, String.format("Unknown function: '%s'", funToken.getContents())));
        }
        call.setFunction(fun);
        this.tokenizer.consume();
        while (!((Token)this.tokenizer.current()).isSymbol(")") && ((Token)this.tokenizer.current()).isNotEnd()) {
            if (!call.getParameters().isEmpty()) {
                this.expect(Token.TokenType.SYMBOL, ",");
            }
            call.addParameter(this.expression());
        }
        this.expect(Token.TokenType.SYMBOL, ")");
        if (fun == null) {
            return Constant.EMPTY;
        }
        if (call.getParameters().size() != fun.getNumberOfArguments()) {
            this.errors.add(ParseError.error(funToken, String.format("Number of arguments for function '%s' do not match. Expected: %d, Found: %d", funToken.getContents(), fun.getNumberOfArguments(), call.getParameters().size())));
            return Constant.EMPTY;
        }
        return call;
    }

    protected void expect(Token.TokenType type, String trigger) {
        if (((Token)this.tokenizer.current()).matches(type, trigger)) {
            this.tokenizer.consume();
        } else {
            this.errors.add(ParseError.error((Position)this.tokenizer.current(), String.format("Unexpected token '%s'. Expected: '%s'", ((Token)this.tokenizer.current()).getSource(), trigger)));
        }
    }

    static {
        Parser.registerFunction("sin", Functions.SIN);
        Parser.registerFunction("cos", Functions.COS);
        Parser.registerFunction("tan", Functions.TAN);
        Parser.registerFunction("sinh", Functions.SINH);
        Parser.registerFunction("cosh", Functions.COSH);
        Parser.registerFunction("tanh", Functions.TANH);
        Parser.registerFunction("asin", Functions.ASIN);
        Parser.registerFunction("acos", Functions.ACOS);
        Parser.registerFunction("atan", Functions.ATAN);
        Parser.registerFunction("atan2", Functions.ATAN2);
        Parser.registerFunction("deg", Functions.DEG);
        Parser.registerFunction("rad", Functions.RAD);
        Parser.registerFunction("abs", Functions.ABS);
        Parser.registerFunction("round", Functions.ROUND);
        Parser.registerFunction("ceil", Functions.CEIL);
        Parser.registerFunction("floor", Functions.FLOOR);
        Parser.registerFunction("exp", Functions.EXP);
        Parser.registerFunction("ln", Functions.LN);
        Parser.registerFunction("log", Functions.LOG);
        Parser.registerFunction("sqrt", Functions.SQRT);
        Parser.registerFunction("min", Functions.MIN);
        Parser.registerFunction("max", Functions.MAX);
        Parser.registerFunction("rnd", Functions.RND);
        Parser.registerFunction("sign", Functions.SIGN);
        Parser.registerFunction("if", Functions.IF);
    }
}

