/*
 * Decompiled with CFR 0.152.
 */
package com.samjakob.spigui.menu;

import com.samjakob.spigui.SpiGUI;
import com.samjakob.spigui.buttons.SGButton;
import com.samjakob.spigui.toolbar.SGToolbarBuilder;
import com.samjakob.spigui.toolbar.SGToolbarButtonType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.java.JavaPlugin;

public class SGMenu
implements InventoryHolder {
    private final JavaPlugin owner;
    private final SpiGUI spiGUI;
    private String name;
    private String tag;
    private int rowsPerPage;
    private final Map<Integer, SGButton> items;
    private final HashSet<Integer> stickiedSlots;
    private int currentPage;
    private boolean blockDefaultInteractions;
    private boolean enableAutomaticPagination;
    private SGToolbarBuilder toolbarBuilder;
    private Consumer<SGMenu> onClose;
    private Consumer<SGMenu> onPageChange;

    public SGMenu(JavaPlugin owner, SpiGUI spiGUI, String name, int rowsPerPage, String tag) {
        this.owner = owner;
        this.spiGUI = spiGUI;
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        this.rowsPerPage = rowsPerPage;
        this.tag = tag;
        this.items = new HashMap<Integer, SGButton>();
        this.stickiedSlots = new HashSet();
        this.currentPage = 0;
    }

    public void setBlockDefaultInteractions(boolean blockDefaultInteractions) {
        this.blockDefaultInteractions = blockDefaultInteractions;
    }

    public Boolean areDefaultInteractionsBlocked() {
        return this.blockDefaultInteractions;
    }

    public void setAutomaticPaginationEnabled(boolean enableAutomaticPagination) {
        this.enableAutomaticPagination = enableAutomaticPagination;
    }

    public Boolean isAutomaticPaginationEnabled() {
        return this.enableAutomaticPagination;
    }

    public void setToolbarBuilder(SGToolbarBuilder toolbarBuilder) {
        this.toolbarBuilder = toolbarBuilder;
    }

    public SGToolbarBuilder getToolbarBuilder() {
        return this.toolbarBuilder;
    }

    public JavaPlugin getOwner() {
        return this.owner;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public int getPageSize() {
        return this.rowsPerPage * 9;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setName(String name) {
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
    }

    public void setRawName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addButton(SGButton button) {
        if (this.getHighestFilledSlot() == 0 && this.getButton(0) == null) {
            this.setButton(0, button);
            return;
        }
        this.setButton(this.getHighestFilledSlot() + 1, button);
    }

    public void addButtons(SGButton ... buttons) {
        for (SGButton button : buttons) {
            this.addButton(button);
        }
    }

    public void setButton(int slot, SGButton button) {
        this.items.put(slot, button);
    }

    public void setButton(int page, int slot, SGButton button) {
        if (slot < 0 || slot > this.getPageSize()) {
            return;
        }
        this.setButton(page * this.getPageSize() + slot, button);
    }

    public void removeButton(int slot) {
        this.items.remove(slot);
    }

    public void removeButton(int page, int slot) {
        if (slot < 0 || slot > this.getPageSize()) {
            return;
        }
        this.removeButton(page * this.getPageSize() + slot);
    }

    public SGButton getButton(int slot) {
        if (slot < 0 || slot > this.getHighestFilledSlot()) {
            return null;
        }
        return this.items.get(slot);
    }

    public SGButton getButton(int page, int slot) {
        if (slot < 0 || slot > this.getPageSize()) {
            return null;
        }
        return this.getButton(page * this.getPageSize() + slot);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
        if (this.onPageChange != null) {
            this.onPageChange.accept(this);
        }
    }

    public int getMaxPage() {
        return (int)Math.ceil(((double)this.getHighestFilledSlot() + 1.0) / (double)this.getPageSize());
    }

    public int getHighestFilledSlot() {
        int slot = 0;
        for (int nextSlot : this.items.keySet()) {
            if (this.items.get(nextSlot) == null || nextSlot <= slot) continue;
            slot = nextSlot;
        }
        return slot;
    }

    public boolean nextPage(HumanEntity viewer) {
        if (this.currentPage < this.getMaxPage() - 1) {
            ++this.currentPage;
            this.refreshInventory(viewer);
            if (this.onPageChange != null) {
                this.onPageChange.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean previousPage(HumanEntity viewer) {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.refreshInventory(viewer);
            if (this.onPageChange != null) {
                this.onPageChange.accept(this);
            }
            return true;
        }
        return false;
    }

    public void stickSlot(int slot) {
        if (slot < 0 || slot >= this.getPageSize()) {
            return;
        }
        this.stickiedSlots.add(slot);
    }

    public void unstickSlot(int slot) {
        this.stickiedSlots.remove(slot);
    }

    public void clearStickiedSlots() {
        this.stickiedSlots.clear();
    }

    public boolean isStickiedSlot(int slot) {
        if (slot < 0 || slot >= this.getPageSize()) {
            return false;
        }
        return this.stickiedSlots.contains(slot);
    }

    public void clearAllButStickiedSlots() {
        this.currentPage = 0;
        this.items.entrySet().removeIf(item -> !this.isStickiedSlot((Integer)item.getKey()));
    }

    public Consumer<SGMenu> getOnClose() {
        return this.onClose;
    }

    public void setOnClose(Consumer<SGMenu> onClose) {
        this.onClose = onClose;
    }

    public Consumer<SGMenu> getOnPageChange() {
        return this.onPageChange;
    }

    public void setOnPageChange(Consumer<SGMenu> onPageChange) {
        this.onPageChange = onPageChange;
    }

    public void refreshInventory(HumanEntity viewer) {
        if (!(viewer.getOpenInventory().getTopInventory().getHolder() instanceof SGMenu) || viewer.getOpenInventory().getTopInventory().getHolder() != this) {
            return;
        }
        if (viewer.getOpenInventory().getTopInventory().getSize() != this.getPageSize() + (this.getMaxPage() > 0 ? 9 : 0)) {
            viewer.openInventory(this.getInventory());
            return;
        }
        String newName = this.name.replace("{currentPage}", String.valueOf(this.currentPage + 1)).replace("{maxPage}", String.valueOf(this.getMaxPage()));
        if (!viewer.getOpenInventory().getTitle().equals(newName)) {
            viewer.openInventory(this.getInventory());
            return;
        }
        viewer.getOpenInventory().getTopInventory().setContents(this.getInventory().getContents());
    }

    public Inventory getInventory() {
        boolean isAutomaticPaginationEnabled = this.spiGUI.isAutomaticPaginationEnabled();
        if (this.isAutomaticPaginationEnabled() != null) {
            isAutomaticPaginationEnabled = this.isAutomaticPaginationEnabled();
        }
        boolean needsPagination = this.getMaxPage() > 0 && isAutomaticPaginationEnabled;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)(needsPagination ? this.getPageSize() + 9 : this.getPageSize()), (String)this.name.replace("{currentPage}", String.valueOf(this.currentPage + 1)).replace("{maxPage}", String.valueOf(this.getMaxPage())));
        for (int key = this.currentPage * this.getPageSize(); key < (this.currentPage + 1) * this.getPageSize() && key <= this.getHighestFilledSlot(); ++key) {
            if (!this.items.containsKey(key)) continue;
            inventory.setItem(key - this.currentPage * this.getPageSize(), this.items.get(key).getIcon());
        }
        for (int stickiedSlot : this.stickiedSlots) {
            inventory.setItem(stickiedSlot, this.items.get(stickiedSlot).getIcon());
        }
        if (needsPagination) {
            int pageSize;
            SGToolbarBuilder toolbarButtonBuilder = this.spiGUI.getDefaultToolbarBuilder();
            if (this.getToolbarBuilder() != null) {
                toolbarButtonBuilder = this.getToolbarBuilder();
            }
            for (int i = pageSize = this.getPageSize(); i < pageSize + 9; ++i) {
                int offset = i - pageSize;
                SGButton paginationButton = toolbarButtonBuilder.buildToolbarButton(offset, this.getCurrentPage(), SGToolbarButtonType.getDefaultForSlot(offset), this);
                inventory.setItem(i, paginationButton != null ? paginationButton.getIcon() : null);
            }
        }
        return inventory;
    }
}

