/*
 * Decompiled with CFR 0.152.
 */
package com.samjakob.spigui;

import com.samjakob.spigui.menu.SGMenu;
import com.samjakob.spigui.menu.SGMenuListener;
import com.samjakob.spigui.menu.SGOpenMenu;
import com.samjakob.spigui.toolbar.SGDefaultToolbarBuilder;
import com.samjakob.spigui.toolbar.SGToolbarBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpiGUI {
    private final JavaPlugin plugin;
    private boolean blockDefaultInteractions = true;
    private boolean enableAutomaticPagination = true;
    private SGToolbarBuilder defaultToolbarBuilder = new SGDefaultToolbarBuilder();

    public SpiGUI(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)new SGMenuListener(plugin, this), (Plugin)plugin);
    }

    public SGMenu create(String name, int rows) {
        return this.create(name, rows, null);
    }

    public SGMenu create(String name, int rows, String tag) {
        return new SGMenu(this.plugin, this, name, rows, tag);
    }

    public void setBlockDefaultInteractions(boolean blockDefaultInteractions) {
        this.blockDefaultInteractions = blockDefaultInteractions;
    }

    public boolean areDefaultInteractionsBlocked() {
        return this.blockDefaultInteractions;
    }

    public void setEnableAutomaticPagination(boolean enableAutomaticPagination) {
        this.enableAutomaticPagination = enableAutomaticPagination;
    }

    public boolean isAutomaticPaginationEnabled() {
        return this.enableAutomaticPagination;
    }

    public void setDefaultToolbarBuilder(SGToolbarBuilder defaultToolbarBuilder) {
        this.defaultToolbarBuilder = defaultToolbarBuilder;
    }

    public SGToolbarBuilder getDefaultToolbarBuilder() {
        return this.defaultToolbarBuilder;
    }

    public List<SGOpenMenu> findOpenWithTag(String tag) {
        ArrayList<SGOpenMenu> foundInventories = new ArrayList<SGOpenMenu>();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            SGMenu inventory;
            Inventory topInventory;
            if (player.getOpenInventory().getTopInventory() == null || (topInventory = player.getOpenInventory().getTopInventory()).getHolder() == null || !(topInventory.getHolder() instanceof SGMenu) || !Objects.equals((inventory = (SGMenu)topInventory.getHolder()).getTag(), tag)) continue;
            foundInventories.add(new SGOpenMenu(inventory, player));
        }
        return foundInventories;
    }
}

