/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.utilities;

import com.rollbar.utilities.ArgumentNullException;
import com.rollbar.utilities.InvalidLengthException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validate {
    private Validate() throws InstantiationException {
        throw new InstantiationException("This utility class is not created for instantiation");
    }

    public static void isNotNullOrWhitespace(String x, String name) throws ArgumentNullException {
        if (x == null || x.trim().isEmpty()) {
            throw new ArgumentNullException(name);
        }
    }

    public static void maxLength(String x, int max, String name) throws InvalidLengthException {
        if (x.length() > max) {
            throw InvalidLengthException.TooLong(name, max);
        }
    }

    public static <T> void minLength(T[] x, int min, String name) throws InvalidLengthException {
        if (x.length < min) {
            throw InvalidLengthException.TooShort(name, min);
        }
    }

    public static <T> void isNotNull(T data, String name) throws ArgumentNullException {
        if (data == null) {
            throw new ArgumentNullException(name);
        }
    }
}

