/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.utilities;

import com.rollbar.utilities.JsonSerializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Extensible<T extends Extensible<T>>
implements JsonSerializable {
    private Set<String> knownMembers;
    private final TreeMap<String, Object> members;

    protected Extensible(Map<String, Object> members) {
        this.members = members == null ? new TreeMap() : new TreeMap<String, Object>(members);
    }

    protected abstract Set<String> getKnownMembers();

    private Set<String> knownMembers() {
        if (this.knownMembers == null) {
            this.knownMembers = this.getKnownMembers();
        }
        return this.knownMembers;
    }

    private boolean isKnownMember(String name) {
        return this.knownMembers().contains(name);
    }

    public Object get(String name) {
        return this.members.get(name);
    }

    public abstract T copy();

    public T put(String name, Object value) throws IllegalArgumentException {
        if (this.isKnownMember(name)) {
            String msgFmt = "'%s' is a known member and must be set with the corresponding method";
            throw new IllegalArgumentException(String.format("'%s' is a known member and must be set with the corresponding method", name));
        }
        T returnVal = this.copy();
        ((Extensible)returnVal).members.put(name, value);
        T returned = returnVal;
        return returned;
    }

    protected void putKnown(String name, Object value) {
        if (!this.isKnownMember(name)) {
            String msg = "Can only set known values with this method. %s not known";
            throw new IllegalArgumentException(String.format("Can only set known values with this method. %s not known", name));
        }
        this.members.put(name, value);
    }

    public Set<String> keys(boolean withoutKnownMembers) {
        TreeSet<String> keys = new TreeSet<String>(this.members.keySet());
        if (withoutKnownMembers) {
            keys.removeAll(this.knownMembers());
        }
        return keys;
    }

    public Map<String, Object> getMembers() {
        return new TreeMap<String, Object>((SortedMap<String, Object>)this.members);
    }

    @Override
    public Map<String, Object> asJson() {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        for (String string : this.knownMembers()) {
            if (!this.members.containsKey(string) || this.members.get(string) == null) continue;
            json.put(string, this.members.get(string));
        }
        for (Map.Entry entry : this.members.entrySet()) {
            if (json.containsKey(entry.getKey())) continue;
            json.put((String)entry.getKey(), entry.getValue());
        }
        return json;
    }
}

