/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.transformer;

import com.rollbar.api.payload.data.Data;
import com.rollbar.notifier.transformer.Transformer;
import java.util.List;

public class TransformerPipeline
implements Transformer {
    private final List<Transformer> pipeline;

    public TransformerPipeline() {
        this(null);
    }

    public TransformerPipeline(List<Transformer> pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public Data transform(Data data) {
        if (this.usePipeline()) {
            return this.pipeline(data);
        }
        return data;
    }

    private boolean usePipeline() {
        return this.pipeline != null && !this.pipeline.isEmpty();
    }

    private Data pipeline(Data data) {
        for (Transformer transformer : this.pipeline) {
            data = transformer.transform(data);
        }
        return data;
    }
}

