/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender.result;

import com.rollbar.notifier.sender.result.Result;
import com.rollbar.notifier.util.ObjectsUtils;

public class Response {
    private int status;
    private Result result;

    Response(Builder builder) {
        this.status = builder.status;
        this.result = builder.result;
    }

    public int getStatus() {
        return this.status;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return this.status == response.status && ObjectsUtils.equals(this.result, response.result);
    }

    public int hashCode() {
        return ObjectsUtils.hash(this.status, this.result);
    }

    public String toString() {
        return "Response{status=" + this.status + ", result=" + this.result + '}';
    }

    public static final class Builder {
        private int status;
        private Result result;

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder result(Result result) {
            this.result = result;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

